/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.easyapi.config;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import net.pitan76.easyapi.config.IConfig;

public class Config
implements IConfig {
    public Map<String, Object> configMap = new LinkedHashMap<String, Object>();

    public Config(File file) {
        this.load(file);
    }

    public Config(String file) {
        this(new File(file));
    }

    public Config() {
    }

    public Config(Config config) {
        this.configMap = config.configMap;
    }

    public boolean has(String key) {
        if (this.configMap == null) {
            return false;
        }
        return this.configMap.containsKey(key);
    }

    @Override
    public Object get(String key) {
        try {
            key = key.replace("\\.", "$&#92;$");
            String[] keyList = key.split("\\.");
            if (keyList.length == 1) {
                key = key.replace("$&#92;$", ".");
                return this.configMap.get(key);
            }
            int i = 0;
            Map inMap = new LinkedHashMap();
            for (String k : keyList) {
                k = k.replace("$&#92;$", ".");
                if (keyList.length == ++i) {
                    return inMap.get(k);
                }
                inMap = i == 1 ? (Map)this.configMap.get(k) : (Map)inMap.get(k);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getString(String key) {
        return (String)this.get(key);
    }

    @Override
    public int getInt(String key) {
        Object obj = this.get(key);
        if (obj instanceof Double) {
            return ((Double)obj).intValue();
        }
        if (obj instanceof Short) {
            return ((Short)obj).intValue();
        }
        if (obj instanceof Long) {
            return ((Long)obj).intValue();
        }
        return (Integer)obj;
    }

    public double getDouble(String key) {
        return (Double)this.get(key);
    }

    @Override
    public boolean getBoolean(String key) {
        try {
            return (Boolean)this.get(key);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object getOrDefault(String key, Object defaultValue) {
        if (this.has(key)) {
            return this.get(key);
        }
        return defaultValue;
    }

    public String getStringOrDefault(String key, String defaultValue) {
        if (this.has(key)) {
            return this.getString(key);
        }
        return defaultValue;
    }

    public int getIntOrDefault(String key, int defaultValue) {
        if (this.has(key)) {
            return this.getInt(key);
        }
        return defaultValue;
    }

    public double getDoubleOrDefault(String key, double defaultValue) {
        if (this.has(key)) {
            return this.getDouble(key);
        }
        return defaultValue;
    }

    public boolean getBooleanOrDefault(String key, boolean defaultValue) {
        if (this.has(key)) {
            return this.getBoolean(key);
        }
        return defaultValue;
    }

    public Object getOrCreate(String key, Object defaultValue) {
        if (this.has(key)) {
            return this.get(key);
        }
        this.set(key, defaultValue);
        return defaultValue;
    }

    public String getStringOrCreate(String key, String defaultValue) {
        if (this.has(key)) {
            return this.getString(key);
        }
        this.setString(key, defaultValue);
        return defaultValue;
    }

    public int getIntOrCreate(String key, int defaultValue) {
        if (this.has(key)) {
            return this.getInt(key);
        }
        this.setInt(key, defaultValue);
        return defaultValue;
    }

    public double getDoubleOrCreate(String key, double defaultValue) {
        if (this.has(key)) {
            return this.getDouble(key);
        }
        this.setDouble(key, defaultValue);
        return defaultValue;
    }

    public boolean getBooleanOrCreate(String key, boolean defaultValue) {
        if (this.has(key)) {
            return this.getBoolean(key);
        }
        this.setBoolean(key, defaultValue);
        return defaultValue;
    }

    @Override
    public boolean set(String key, Object value) {
        try {
            key = key.replace("\\.", "$&#92;$");
            String[] keyList = key.split("\\.");
            if (keyList.length == 1) {
                key = key.replace("$&#92;$", ".");
                this.configMap.put(key, value);
                return true;
            }
            int i = 0;
            LinkedHashMap inMap = new LinkedHashMap();
            for (String k : keyList) {
                k = k.replace("$&#92;$", ".");
                if (keyList.length == ++i) {
                    inMap.put(k, value);
                    continue;
                }
                LinkedHashMap beforeInMap = inMap;
                inMap = this.configMap.containsKey(k) && i == 1 ? (LinkedHashMap)this.configMap.get(k) : (beforeInMap.containsKey(k) ? (LinkedHashMap)beforeInMap.get(k) : new LinkedHashMap());
                if (i == 1) {
                    this.configMap.put(k, inMap);
                    continue;
                }
                beforeInMap.put(k, inMap);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean setString(String key, String value) {
        return this.set(key, value);
    }

    @Override
    public boolean setInt(String key, int value) {
        return this.set(key, value);
    }

    public boolean setDouble(String key, double value) {
        return this.set(key, value);
    }

    @Override
    public boolean setBoolean(String key, boolean value) {
        return this.set(key, value);
    }

    public boolean remove(String key) {
        return this.configMap.remove(key) != null;
    }

    @Override
    public boolean load(String file) {
        return this.load(new File(file));
    }

    @Override
    public boolean load(File file) {
        return false;
    }

    @Override
    public boolean save(String file) {
        return this.save(new File(file));
    }

    @Override
    public boolean save(File file) {
        return this.save(file, true);
    }

    @Override
    public boolean save(String file, boolean pretty) {
        return this.save(new File(file), pretty);
    }

    @Override
    public boolean save(File file, boolean pretty) {
        return false;
    }
}

