/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.pitan76.mcpitanlib.api.client.gui.widget.CompatibleTexturedButtonWidget;
import net.pitan76.mcpitanlib.api.client.render.DrawObjectDM;
import net.pitan76.mcpitanlib.api.client.render.handledscreen.KeyEventArgs;
import net.pitan76.mcpitanlib.api.client.render.handledscreen.RenderArgs;
import net.pitan76.mcpitanlib.api.client.render.screen.RenderBackgroundTextureArgs;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.IdentifierUtil;
import net.pitan76.mcpitanlib.api.util.client.RenderUtil;

public abstract class SimpleScreen
extends Screen {
    public int width;
    public int height;
    public Font textRenderer;
    public ItemRenderer itemRenderer;
    public Component title;
    public Minecraft client;

    public SimpleScreen(Component title) {
        super(title);
        this.fixScreen();
        this.title = title;
    }

    public <T extends GuiEventListener & Renderable> T addDrawableChild_compatibility(T drawableElement) {
        return (T)super.addRenderableWidget(drawableElement);
    }

    public <T extends GuiEventListener & NarratableEntry> T addSelectableChild_compatibility(T selectableElement) {
        return (T)super.addWidget(selectableElement);
    }

    public CompatibleTexturedButtonWidget addDrawableCTBW(CompatibleTexturedButtonWidget widget) {
        return this.addDrawableChild_compatibility(widget);
    }

    public void callDrawTexture(DrawObjectDM drawObjectDM, ResourceLocation texture, int x, int y, int u, int v, int width, int height) {
        drawObjectDM.getContext().blit(RenderType::guiTextured, texture, x, y, (float)u, (float)v, width, height, 256, 256);
    }

    public void callDrawTexture(DrawObjectDM drawObjectDM, CompatIdentifier texture, int x, int y, int u, int v, int width, int height) {
        this.callDrawTexture(drawObjectDM, texture.toMinecraft(), x, y, u, v, width, height);
    }

    @Deprecated
    public void renderBackground(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderBackground(new RenderArgs(new DrawObjectDM(context, this), mouseX, mouseY, delta));
    }

    public void renderBackground(RenderArgs args) {
        super.renderBackground(args.drawObjectDM.getContext(), args.mouseX, args.mouseY, args.delta);
    }

    public void render(RenderArgs args) {
        super.render(args.drawObjectDM.getContext(), args.mouseX, args.mouseY, args.delta);
    }

    public void resizeOverride(Minecraft client, int width, int height) {
    }

    public void initOverride() {
    }

    @Deprecated
    protected void init() {
        super.init();
        this.fixScreen();
        this.initOverride();
    }

    @Deprecated
    public void resize(Minecraft client, int width, int height) {
        super.resize(client, width, height);
        this.fixScreen();
        this.resizeOverride(client, width, height);
    }

    public void fixScreen() {
        this.textRenderer = this.font;
        this.itemRenderer = Minecraft.getInstance().getItemRenderer();
        this.width = ((Screen)this).width;
        this.height = ((Screen)this).height;
        this.client = this.minecraft == null ? Minecraft.getInstance() : this.minecraft;
    }

    public void setTextRenderer(Font textRenderer) {
        this.textRenderer = textRenderer;
        this.font = textRenderer;
    }

    public void setItemRenderer(ItemRenderer itemRenderer) {
        this.itemRenderer = itemRenderer;
    }

    public void setWidth(int width) {
        this.width = width;
        ((Screen)this).width = width;
    }

    public void setHeight(int height) {
        this.height = height;
        ((Screen)this).height = height;
    }

    @Deprecated
    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        DrawObjectDM drawObjectDM = new DrawObjectDM(context, this);
        this.render(new RenderArgs(drawObjectDM, mouseX, mouseY, delta));
    }

    public boolean keyReleased(KeyEventArgs args) {
        return super.keyReleased(args.keyCode, args.scanCode, args.modifiers);
    }

    public boolean keyPressed(KeyEventArgs args) {
        return super.keyPressed(args.keyCode, args.scanCode, args.modifiers);
    }

    public void renderBackgroundTexture(RenderBackgroundTextureArgs args) {
        if (this.getBackgroundTexture() != null) {
            Screen.renderMenuBackgroundTexture((GuiGraphics)args.getDrawObjectDM().getContext(), (ResourceLocation)this.getBackgroundTexture(), (int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height);
        }
        RenderUtil.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.callDrawTexture(args.drawObjectDM, this.getBackgroundTexture(), 0, 0, 0, 0, this.width, this.height);
    }

    @Deprecated
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return this.keyReleased(new KeyEventArgs(keyCode, scanCode, modifiers));
    }

    @Deprecated
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.keyPressed(new KeyEventArgs(keyCode, scanCode, modifiers));
    }

    @Deprecated
    public void renderMenuBackground(GuiGraphics context) {
        this.renderBackgroundTexture(new RenderBackgroundTextureArgs(new DrawObjectDM(context, this), 0));
    }

    public void closeOverride() {
        super.onClose();
    }

    public void removedOverride() {
        super.removed();
    }

    public void onClose() {
        this.closeOverride();
    }

    public void removed() {
        this.removedOverride();
    }

    public ResourceLocation getBackgroundTexture() {
        return IdentifierUtil.from(this.getCompatBackgroundTexture());
    }

    public CompatIdentifier getCompatBackgroundTexture() {
        return null;
    }
}

