/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.item;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.pitan76.mcpitanlib.api.entity.effect.CompatStatusEffectInstance;

public class CompatFoodComponent {
    private int hunger;
    private float saturation;
    private boolean meat;
    private boolean alwaysEdible;
    private boolean snack;
    private final List<Pair<MobEffectInstance, Float>> statusEffects = new ArrayList<Pair<MobEffectInstance, Float>>();
    private FoodProperties latestComponent = null;

    public static CompatFoodComponent create() {
        return new CompatFoodComponent();
    }

    public CompatFoodComponent setHunger(int hunger) {
        this.hunger = hunger;
        return this;
    }

    public CompatFoodComponent setSaturation(float saturation) {
        this.saturation = saturation;
        return this;
    }

    public CompatFoodComponent setAlwaysEdible() {
        this.alwaysEdible = true;
        return this;
    }

    public CompatFoodComponent setSnack() {
        this.snack = true;
        return this;
    }

    public CompatFoodComponent setMeat() {
        this.meat = true;
        return this;
    }

    @Deprecated
    public CompatFoodComponent addStatusEffect(MobEffectInstance effect, float chance) {
        this.statusEffects.add((Pair<MobEffectInstance, Float>)Pair.of((Object)effect, (Object)Float.valueOf(chance)));
        return this;
    }

    public CompatFoodComponent addStatusEffect(CompatStatusEffectInstance instance, float chance) {
        return this.addStatusEffect(instance.getInstance(), chance);
    }

    public FoodProperties.Builder getVanillaBuilder() {
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder.nutrition(this.hunger).saturationModifier(this.saturation);
        if (this.alwaysEdible) {
            builder.alwaysEdible();
        }
        return builder;
    }

    public FoodProperties build() {
        if (this.latestComponent != null) {
            return this.latestComponent;
        }
        float eatSeconds = 1.6f;
        if (this.snack) {
            eatSeconds = 0.8f;
        }
        if (this.meat) {
            eatSeconds = 1.6f;
        }
        this.latestComponent = new FoodProperties(this.hunger, this.saturation, this.alwaysEdible);
        return this.latestComponent;
    }

    public FoodProperties vanillaBuild() {
        if (this.latestComponent != null) {
            return this.latestComponent;
        }
        this.latestComponent = this.getVanillaBuilder().build();
        return this.latestComponent;
    }

    public int getHunger() {
        return this.hunger;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public boolean isMeat() {
        return this.meat;
    }

    public boolean isSnack() {
        return this.snack;
    }

    public boolean isAlwaysEdible() {
        return this.alwaysEdible;
    }

    @Deprecated
    public List<Pair<MobEffectInstance, Float>> getStatusEffects() {
        return this.statusEffects;
    }

    public List<Pair<CompatStatusEffectInstance, Float>> getCompatStatusEffects() {
        ArrayList<Pair<CompatStatusEffectInstance, Float>> compatStatusEffects = new ArrayList<Pair<CompatStatusEffectInstance, Float>>();
        for (Pair<MobEffectInstance, Float> pair : this.statusEffects) {
            compatStatusEffects.add((Pair<CompatStatusEffectInstance, Float>)Pair.of((Object)new CompatStatusEffectInstance((MobEffectInstance)pair.getFirst()), (Object)((Float)pair.getSecond())));
        }
        return compatStatusEffects;
    }
}

