/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.item;

import java.util.EnumMap;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.pitan76.mcpitanlib.api.item.ArmorEquipmentType;
import net.pitan76.mcpitanlib.api.util.IngredientUtil;

public interface CompatibleArmorMaterial {
    public int getDurability(ArmorEquipmentType var1);

    public int getProtection(ArmorEquipmentType var1);

    public int getEnchantability();

    public SoundEvent getEquipSound();

    default public Ingredient getRepairIngredient() {
        return IngredientUtil.fromTagByIdentifier(this.getRepairTag().location());
    }

    default public String getName() {
        return this.getId().getPath();
    }

    public ResourceLocation getId();

    public float getToughness();

    public float getKnockbackResistance();

    default public TagKey<Item> getRepairTag() {
        return ItemTags.REPAIRS_IRON_ARMOR;
    }

    @Deprecated
    default public ArmorMaterial build() {
        return new ArmorMaterial(0, this.getDefense(), this.getEnchantability(), Holder.direct((Object)this.getEquipSound()), this.getToughness(), this.getKnockbackResistance(), this.getRepairTag(), ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)this.getId()));
    }

    default public EnumMap<ArmorType, Integer> getDefense() {
        EnumMap<ArmorType, Integer> map = new EnumMap<ArmorType, Integer>(ArmorType.class);
        map.put(ArmorType.HELMET, this.getProtection(ArmorEquipmentType.HEAD));
        map.put(ArmorType.CHESTPLATE, this.getProtection(ArmorEquipmentType.CHEST));
        map.put(ArmorType.LEGGINGS, this.getProtection(ArmorEquipmentType.LEGS));
        map.put(ArmorType.BOOTS, this.getProtection(ArmorEquipmentType.FEET));
        return map;
    }
}

