/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.network;

import dev.architectury.impl.NetworkAggregator;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.transformers.PacketTransformer;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.pitan76.mcpitanlib.core.network.BufPayload;

public class ClientNetworking {
    public static void send(ResourceLocation identifier, FriendlyByteBuf buf) {
        BufPayload payload = new BufPayload(buf, identifier);
        NetworkManager.sendToServer((CustomPacketPayload)payload);
    }

    public static void registerReceiver(ResourceLocation identifier, ClientNetworkHandler handler) {
        CustomPacketPayload.Type<BufPayload> id = BufPayload.id(identifier);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, id, BufPayload.getCodec(id), (payload, context) -> {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])payload.getData()));
            LocalPlayer player = null;
            if (context.getPlayer() instanceof LocalPlayer) {
                player = (LocalPlayer)context.getPlayer();
            }
            handler.receive(Minecraft.getInstance(), player, buf);
            buf.release();
        });
    }

    public static void registerC2SType(CustomPacketPayload.Type<NetworkAggregator.BufCustomPacketPayload> type, StreamCodec<? super RegistryFriendlyByteBuf, NetworkAggregator.BufCustomPacketPayload> codec, List<PacketTransformer> packetTransformers) {
    }

    @FunctionalInterface
    public static interface ClientNetworkHandler {
        public void receive(Minecraft var1, LocalPlayer var2, FriendlyByteBuf var3);
    }
}

