/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.Optional;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.pitan76.mcpitanlib.api.event.result.EventResult;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;

public class StackActionResult
extends CompatActionResult {
    private final ItemStack stack;
    private final CompatActionResult compatActionResult;

    public StackActionResult(InteractionResult actionResult, EventResult eventResult, ItemStack stack) {
        this(new CompatActionResult(actionResult, eventResult), stack);
    }

    public StackActionResult(CompatActionResult actionResult, ItemStack stack) {
        super(null, null);
        this.compatActionResult = actionResult;
        this.stack = stack;
    }

    @Override
    public InteractionResult toActionResult() {
        return this.compatActionResult.toActionResult();
    }

    @Override
    public EventResult toEventResult() {
        return this.compatActionResult.toEventResult();
    }

    @Override
    @Deprecated
    public Optional<ItemStack> getNewHandStack() {
        if (this.hasNewStack()) {
            return this.compatActionResult.getNewHandStack();
        }
        return Optional.empty();
    }

    public boolean hasNewStack() {
        return this.compatActionResult.getNewHandStack().isPresent();
    }

    public boolean hasStack() {
        return this.getStack() != null;
    }

    public CompatActionResult asCompatActionResult() {
        return this.compatActionResult;
    }

    public static StackActionResult create(CompatActionResult compatActionResult, ItemStack stack) {
        if (compatActionResult.getNewHandStack().isPresent()) {
            return new StackActionResult(compatActionResult, compatActionResult.getNewHandStack().get());
        }
        return new StackActionResult(compatActionResult, stack);
    }

    public static StackActionResult create(CompatActionResult compatActionResult) {
        return new StackActionResult(compatActionResult, null);
    }

    public static StackActionResult create(InteractionResult actionResult, EventResult eventResult, ItemStack stack) {
        return new StackActionResult(actionResult, eventResult, stack);
    }

    public static StackActionResult create(InteractionResult actionResult, ItemStack stack) {
        return new StackActionResult(actionResult, null, stack);
    }

    public static StackActionResult success(ItemStack stack) {
        CompatActionResult compatActionResult = CompatActionResult.create((InteractionResult)InteractionResult.SUCCESS.heldItemTransformedTo(stack));
        return StackActionResult.create(compatActionResult, stack);
    }

    public static StackActionResult successServer(ItemStack stack) {
        CompatActionResult compatActionResult = CompatActionResult.create((InteractionResult)InteractionResult.SUCCESS_SERVER.heldItemTransformedTo(stack));
        return StackActionResult.create(compatActionResult, stack);
    }

    public static StackActionResult consume(ItemStack stack) {
        CompatActionResult compatActionResult = CompatActionResult.create((InteractionResult)InteractionResult.CONSUME.heldItemTransformedTo(stack));
        return StackActionResult.create(compatActionResult, stack);
    }

    public static StackActionResult pass(ItemStack stack) {
        return StackActionResult.create(CompatActionResult.PASS, stack);
    }

    public static StackActionResult pass() {
        return StackActionResult.create(CompatActionResult.PASS);
    }

    public static StackActionResult fail(ItemStack stack) {
        return StackActionResult.create(CompatActionResult.FAIL, stack);
    }

    public static StackActionResult fail() {
        return StackActionResult.create(CompatActionResult.FAIL);
    }

    public ItemStack getStack() {
        return this.stack;
    }
}

