/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.math.random;

import java.util.Random;
import net.minecraft.util.RandomSource;

public class CompatRandom {
    private Random javaRandom;
    private RandomSource mcRandom;

    public CompatRandom(Random javaRandom) {
        this.javaRandom = javaRandom;
    }

    public CompatRandom(RandomSource mcRandom) {
        this.mcRandom = mcRandom;
    }

    @Deprecated
    public CompatRandom() {
        this.mcRandom = RandomSource.create();
    }

    @Deprecated
    public CompatRandom(long seed) {
        this.mcRandom = RandomSource.create((long)seed);
    }

    public static CompatRandom of(long seed) {
        return new CompatRandom(seed);
    }

    public static CompatRandom of() {
        return new CompatRandom();
    }

    public void setSeed(long seed) {
        if (this.javaRandom != null) {
            this.javaRandom.setSeed(seed);
        } else {
            this.mcRandom.setSeed(seed);
        }
    }

    public void skip(int count) {
        if (this.javaRandom != null) {
            for (int i = 0; i < count; ++i) {
                this.javaRandom.nextInt();
            }
        } else {
            this.mcRandom.consumeCount(count);
        }
    }

    public void split() {
        if (this.javaRandom != null) {
            this.javaRandom.nextInt();
        } else {
            this.mcRandom.fork();
        }
    }

    public int nextInt() {
        if (this.javaRandom != null) {
            return this.javaRandom.nextInt();
        }
        return this.mcRandom.nextInt();
    }

    public int nextInt(int bound) {
        if (this.javaRandom != null) {
            return this.javaRandom.nextInt(bound);
        }
        return this.mcRandom.nextInt(bound);
    }

    public long nextLong() {
        if (this.javaRandom != null) {
            return this.javaRandom.nextLong();
        }
        return this.mcRandom.nextLong();
    }

    public double nextDouble() {
        if (this.javaRandom != null) {
            return this.javaRandom.nextDouble();
        }
        return this.mcRandom.nextDouble();
    }

    public double nextGaussian() {
        if (this.javaRandom != null) {
            return this.javaRandom.nextGaussian();
        }
        return this.mcRandom.nextGaussian();
    }

    public float nextFloat() {
        if (this.javaRandom != null) {
            return this.javaRandom.nextFloat();
        }
        return this.mcRandom.nextFloat();
    }

    public int nextBetween(int min, int max) {
        if (this.javaRandom != null) {
            return min + this.javaRandom.nextInt(max - min);
        }
        return min + this.mcRandom.nextInt(max - min);
    }

    public int nextBetweenExclusive(int min, int max) {
        if (this.javaRandom != null) {
            return min + this.javaRandom.nextInt(max - min - 1);
        }
        return min + this.mcRandom.nextInt(max - min - 1);
    }

    public boolean nextBoolean() {
        if (this.javaRandom != null) {
            return this.javaRandom.nextBoolean();
        }
        return this.mcRandom.nextBoolean();
    }

    @Deprecated
    public Random getJavaRandom() {
        return this.javaRandom;
    }

    @Deprecated
    public RandomSource getMcRandom() {
        return this.mcRandom;
    }
}

