/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.recipe;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.pitan76.mcpitanlib.api.recipe.v3.CompatRecipe;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.midohra.recipe.RecipeType;
import net.pitan76.mcpitanlib.midohra.recipe.entry.CraftingRecipeEntry;
import net.pitan76.mcpitanlib.midohra.recipe.entry.RecipeEntry;
import net.pitan76.mcpitanlib.midohra.world.World;

public class RecipeUtil {
    public static Collection<Recipe<?>> getMCRecipes(Level world) {
        ArrayList recipes = new ArrayList();
        for (RecipeHolder<?> entry : RecipeUtil.getMCRecipeEntries(world)) {
            recipes.add(entry.value());
        }
        return recipes;
    }

    public static Collection<RecipeHolder<?>> getMCRecipeEntries(Level world) {
        if (world.recipeAccess() instanceof RecipeManager) {
            return ((RecipeManager)world.recipeAccess()).getRecipes();
        }
        return new ArrayList();
    }

    public static Collection<CompatRecipe> getRecipes(Level world) {
        ArrayList<CompatRecipe> recipes = new ArrayList<CompatRecipe>();
        for (RecipeHolder<?> entry : RecipeUtil.getMCRecipeEntries(world)) {
            recipes.add(new CompatRecipe(entry));
        }
        return recipes;
    }

    public static Collection<CompatRecipe> getRecipesByType(Level world, net.minecraft.world.item.crafting.RecipeType<?> type) {
        ArrayList<CompatRecipe> recipes = new ArrayList<CompatRecipe>();
        for (RecipeHolder<?> entry : RecipeUtil.getMCRecipeEntries(world)) {
            if (entry.value().getType() != type) continue;
            recipes.add(new CompatRecipe(entry));
        }
        return recipes;
    }

    public static Collection<CompatRecipe> getRecipes(World world) {
        return RecipeUtil.getRecipes(world.getRaw());
    }

    public static Collection<CompatRecipe> getRecipesByType(World world, RecipeType type) {
        return RecipeUtil.getRecipesByType(world.getRaw(), type.getRaw());
    }

    public static Collection<RecipeEntry> getRecipeEntries(World world) {
        ArrayList<RecipeEntry> entries = new ArrayList<RecipeEntry>();
        for (RecipeHolder<?> entry : RecipeUtil.getMCRecipeEntries(world.getRaw())) {
            entries.add(RecipeEntry.of(entry.value(), CompatIdentifier.fromMinecraft(entry.id().location())));
        }
        return entries;
    }

    public static Collection<net.pitan76.mcpitanlib.midohra.recipe.CraftingRecipe> getCraftingRecipes(World world) {
        ArrayList<net.pitan76.mcpitanlib.midohra.recipe.CraftingRecipe> recipes = new ArrayList<net.pitan76.mcpitanlib.midohra.recipe.CraftingRecipe>();
        for (CompatRecipe recipe : RecipeUtil.getRecipesByType(world, RecipeType.CRAFTING)) {
            if (!(recipe.getRecipe() instanceof CraftingRecipe)) continue;
            recipes.add(net.pitan76.mcpitanlib.midohra.recipe.CraftingRecipe.of((CraftingRecipe)recipe.getRecipe()));
        }
        return recipes;
    }

    public static Collection<CraftingRecipeEntry> getCraftingRecipeEntries(World world) {
        ArrayList<CraftingRecipeEntry> entries = new ArrayList<CraftingRecipeEntry>();
        for (RecipeHolder<?> entry : RecipeUtil.getMCRecipeEntries(world.getRaw())) {
            if (!(entry.value() instanceof CraftingRecipe)) continue;
            entries.add(CraftingRecipeEntry.of((CraftingRecipe)entry.value(), CompatIdentifier.fromMinecraft(entry.id().location())));
        }
        return entries;
    }
}

