/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.world;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.pitan76.mcpitanlib.api.sound.CompatSoundCategory;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvent;
import net.pitan76.mcpitanlib.api.util.math.random.CompatRandom;
import net.pitan76.mcpitanlib.api.util.world.WorldAccessUtil;
import net.pitan76.mcpitanlib.midohra.block.BlockState;
import net.pitan76.mcpitanlib.midohra.block.entity.BlockEntityWrapper;
import net.pitan76.mcpitanlib.midohra.server.MCServer;
import net.pitan76.mcpitanlib.midohra.world.WorldView;

public class WorldAccess
extends WorldView {
    private final LevelAccessor world;

    protected WorldAccess(LevelAccessor world) {
        super(null);
        this.world = world;
    }

    public static WorldAccess of(LevelAccessor world) {
        return new WorldAccess(world);
    }

    protected LevelAccessor getRaw() {
        return this.world;
    }

    public LevelAccessor toMinecraft() {
        return this.getRaw();
    }

    @Override
    public boolean isClient() {
        return WorldAccessUtil.isClient((LevelReader)this.getRaw());
    }

    @Override
    public boolean isServer() {
        return !this.isClient();
    }

    public CompatRandom getRandom() {
        return new CompatRandom(this.getRaw().getRandom());
    }

    public MinecraftServer getServer() {
        return WorldAccessUtil.getServer(this.getRaw());
    }

    @Override
    public BlockEntityWrapper getBlockEntity(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos) {
        return BlockEntityWrapper.of(WorldAccessUtil.getBlockEntity((LevelReader)this.getRaw(), pos.toMinecraft()));
    }

    @Override
    public <T extends BlockEntity> Optional<T> getRawBlockEntity(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, BlockEntityType<T> type) {
        return WorldAccessUtil.getBlockEntity((LevelReader)this.getRaw(), pos.toMinecraft(), type);
    }

    @Override
    public <T extends BlockEntity> BlockEntityWrapper getBlockEntity(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, BlockEntityType<T> type) {
        Optional<BlockEntity> blockEntity = WorldAccessUtil.getBlockEntity((LevelReader)this.getRaw(), pos.toMinecraft(), type);
        return blockEntity.map(BlockEntityWrapper::of).orElse(BlockEntityWrapper.of());
    }

    public boolean removeBlock(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, boolean move) {
        return WorldAccessUtil.removeBlock(this.getRaw(), pos.toMinecraft(), move);
    }

    public boolean breakBlock(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, boolean drop) {
        return WorldAccessUtil.breakBlock(this.getRaw(), pos.toMinecraft(), drop);
    }

    public boolean breakBlock(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, boolean drop, Entity entity) {
        return WorldAccessUtil.breakBlock(this.getRaw(), pos.toMinecraft(), drop, entity);
    }

    @Override
    public BlockState getBlockState(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos) {
        return BlockState.of(WorldAccessUtil.getBlockState(this.getRaw(), pos.toMinecraft()));
    }

    public boolean setBlockState(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, BlockState state, int flags) {
        return WorldAccessUtil.setBlockState(this.getRaw(), pos.toMinecraft(), state.toMinecraft(), flags);
    }

    public boolean setBlockState(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, BlockState state, int flags, int maxUpdateDepth) {
        return WorldAccessUtil.setBlockState(this.getRaw(), pos.toMinecraft(), state.toMinecraft(), flags, maxUpdateDepth);
    }

    public boolean setBlockState(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, BlockState state) {
        return WorldAccessUtil.setBlockState(this.getRaw(), pos.toMinecraft(), state.toMinecraft());
    }

    @Deprecated
    public void playSound(Player playerEntity, BlockPos pos, SoundEvent sound, SoundSource category, float volume, float pitch) {
        this.getRaw().playSound(playerEntity, pos, sound, category, volume, pitch);
    }

    @Deprecated
    public void playSound(Player playerEntity, BlockPos pos, SoundEvent sound, SoundSource category) {
        this.getRaw().playSound(playerEntity, pos, sound, category);
    }

    public void playSound(net.pitan76.mcpitanlib.api.entity.Player player, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, CompatSoundEvent soundEvent, CompatSoundCategory category, float volume, float pitch) {
        this.playSound(player.getEntity(), pos.toMinecraft(), soundEvent.get(), category.get(), volume, pitch);
    }

    public void playSound(net.pitan76.mcpitanlib.api.entity.Player player, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, CompatSoundEvent soundEvent, CompatSoundCategory category) {
        this.playSound(player.getEntity(), pos.toMinecraft(), soundEvent.get(), category.get());
    }

    public void playSound(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, CompatSoundEvent soundEvent, CompatSoundCategory category, float volume, float pitch) {
        this.playSound(null, pos.toMinecraft(), soundEvent.get(), category.get(), volume, pitch);
    }

    public void playSound(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, CompatSoundEvent soundEvent, CompatSoundCategory category) {
        this.playSound(null, pos.toMinecraft(), soundEvent.get(), category.get());
    }

    public MCServer getMCServer() {
        return MCServer.of(this.getServer());
    }
}

