/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.mixin;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.pitan76.mcpitanlib.api.event.item.BonusAttackDamageArgs;
import net.pitan76.mcpitanlib.api.event.item.CraftEvent;
import net.pitan76.mcpitanlib.api.event.item.InventoryTickEvent;
import net.pitan76.mcpitanlib.api.event.item.ItemAppendTooltipEvent;
import net.pitan76.mcpitanlib.api.event.item.ItemBarColorArgs;
import net.pitan76.mcpitanlib.api.event.item.ItemBarStepArgs;
import net.pitan76.mcpitanlib.api.event.item.ItemBarVisibleArgs;
import net.pitan76.mcpitanlib.api.event.item.ItemFinishUsingEvent;
import net.pitan76.mcpitanlib.api.event.item.ItemUseEvent;
import net.pitan76.mcpitanlib.api.event.item.ItemUseOnBlockEvent;
import net.pitan76.mcpitanlib.api.event.item.ItemUseOnEntityEvent;
import net.pitan76.mcpitanlib.api.event.item.PostHitEvent;
import net.pitan76.mcpitanlib.api.event.item.PostMineEvent;
import net.pitan76.mcpitanlib.api.event.v2.ItemEventRegistry;
import net.pitan76.mcpitanlib.api.event.v2.listener.InventoryTickTask;
import net.pitan76.mcpitanlib.api.item.ExtendItemProvider;
import net.pitan76.mcpitanlib.api.item.args.UseActionArgs;
import net.pitan76.mcpitanlib.api.item.consume.CompatUseAction;
import net.pitan76.mcpitanlib.api.item.v2.CompatItemProvider;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import net.pitan76.mcpitanlib.api.util.StackActionResult;
import net.pitan76.mcpitanlib.mixin.ItemUsageContextMixin;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public class ItemMixin {
    @Inject(method={"use(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$use(Level world, Player user, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (this instanceof ExtendItemProvider) {
            ExtendItemProvider provider = (ExtendItemProvider)((Object)this);
            ExtendItemProvider.Options options = new ExtendItemProvider.Options();
            StackActionResult returnValue = provider.onRightClick(new ItemUseEvent(world, user, hand), options);
            if (options.cancel && returnValue != null) {
                cir.setReturnValue((Object)((CompatActionResult)returnValue).toActionResult());
            }
        }
    }

    @Inject(method={"useOn(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$useOnBlock(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        if (this instanceof ExtendItemProvider) {
            ExtendItemProvider provider = (ExtendItemProvider)((Object)this);
            ItemUsageContextMixin contextAccessor = (ItemUsageContextMixin)context;
            ExtendItemProvider.Options options = new ExtendItemProvider.Options();
            CompatActionResult returnValue = provider.onRightClickOnBlock(new ItemUseOnBlockEvent(context.getPlayer(), context.getHand(), contextAccessor.getHitResult()), options);
            if (options.cancel && returnValue != null) {
                cir.setReturnValue((Object)returnValue.toActionResult());
            }
        }
    }

    @Inject(method={"interactLivingEntity(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$useOnEntity(ItemStack stack, Player user, LivingEntity entity, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (this instanceof ExtendItemProvider) {
            ExtendItemProvider provider = (ExtendItemProvider)((Object)this);
            ExtendItemProvider.Options options = new ExtendItemProvider.Options();
            CompatActionResult returnValue = provider.onRightClickOnEntity(new ItemUseOnEntityEvent(stack, user, entity, hand), options);
            if (options.cancel && returnValue != null) {
                cir.setReturnValue((Object)returnValue.toActionResult());
            }
        }
    }

    @Inject(method={"finishUsingItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$finishUsing(ItemStack stack, Level world, LivingEntity user, CallbackInfoReturnable<ItemStack> cir) {
        if (this instanceof ExtendItemProvider) {
            ExtendItemProvider provider = (ExtendItemProvider)((Object)this);
            ExtendItemProvider.Options options = new ExtendItemProvider.Options();
            ItemStack returnValue = provider.onFinishUsing(new ItemFinishUsingEvent(stack, world, user), options);
            if (options.cancel && returnValue != null) {
                cir.setReturnValue((Object)returnValue);
            }
        }
    }

    @Inject(method={"appendHoverText(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$appendTooltip(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type, CallbackInfo ci) {
        if (this instanceof ExtendItemProvider) {
            ExtendItemProvider provider = (ExtendItemProvider)((Object)this);
            ExtendItemProvider.Options options = new ExtendItemProvider.Options();
            provider.appendTooltip(new ItemAppendTooltipEvent(stack, null, tooltip, type, context), options);
            if (options.cancel) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"hurtEnemy(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$postHit(ItemStack stack, LivingEntity target, LivingEntity attacker, CallbackInfoReturnable<Boolean> cir) {
        if (this instanceof ExtendItemProvider) {
            ExtendItemProvider provider = (ExtendItemProvider)((Object)this);
            ExtendItemProvider.Options options = new ExtendItemProvider.Options();
            boolean returnValue = provider.postHit(new PostHitEvent(stack, target, attacker), options);
            if (options.cancel) {
                cir.setReturnValue((Object)returnValue);
            }
        }
    }

    @Inject(method={"mineBlock(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$postMine(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner, CallbackInfoReturnable<Boolean> cir) {
        if (this instanceof ExtendItemProvider) {
            ExtendItemProvider provider = (ExtendItemProvider)((Object)this);
            ExtendItemProvider.Options options = new ExtendItemProvider.Options();
            boolean returnValue = provider.postMine(new PostMineEvent(stack, world, state, pos, miner), options);
            if (options.cancel) {
                cir.setReturnValue((Object)returnValue);
            }
        }
    }

    @Inject(method={"onCraftedPostProcess(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$onCraft(ItemStack stack, Level world, CallbackInfo ci) {
        if (this instanceof ExtendItemProvider) {
            ExtendItemProvider provider = (ExtendItemProvider)((Object)this);
            ExtendItemProvider.Options options = new ExtendItemProvider.Options();
            provider.onCraft(new CraftEvent(stack, world), options);
            if (options.cancel) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"getBarColor(Lnet/minecraft/world/item/ItemStack;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$getItemBarColor(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        if (this instanceof ExtendItemProvider) {
            ExtendItemProvider provider = (ExtendItemProvider)((Object)this);
            ExtendItemProvider.Options options = new ExtendItemProvider.Options();
            int returnValue = provider.getItemBarColor(new ItemBarColorArgs(stack), options);
            if (options.cancel) {
                cir.setReturnValue((Object)returnValue);
            }
        }
    }

    @Inject(method={"isBarVisible(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$isItemBarVisible(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (this instanceof ExtendItemProvider) {
            ExtendItemProvider provider = (ExtendItemProvider)((Object)this);
            ExtendItemProvider.Options options = new ExtendItemProvider.Options();
            boolean returnValue = provider.isItemBarVisible(new ItemBarVisibleArgs(stack), options);
            if (options.cancel) {
                cir.setReturnValue((Object)returnValue);
            }
        }
    }

    @Inject(method={"getBarWidth(Lnet/minecraft/world/item/ItemStack;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$getItemBarStep(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        if (this instanceof ExtendItemProvider) {
            ExtendItemProvider provider = (ExtendItemProvider)((Object)this);
            ExtendItemProvider.Options options = new ExtendItemProvider.Options();
            int returnValue = provider.getItemBarStep(new ItemBarStepArgs(stack), options);
            if (options.cancel) {
                cir.setReturnValue((Object)returnValue);
            }
        }
    }

    @Inject(method={"getAttackDamageBonus(Lnet/minecraft/world/entity/Entity;FLnet/minecraft/world/damagesource/DamageSource;)F"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$getBonusAttackDamage(Entity target, float baseAttackDamage, DamageSource damageSource, CallbackInfoReturnable<Float> cir) {
        if (this instanceof ExtendItemProvider) {
            ExtendItemProvider provider = (ExtendItemProvider)((Object)this);
            ExtendItemProvider.Options options = new ExtendItemProvider.Options();
            float returnValue = provider.getBonusAttackDamage(new BonusAttackDamageArgs(target, baseAttackDamage, damageSource), options);
            if (options.cancel) {
                cir.setReturnValue((Object)Float.valueOf(returnValue));
            }
        }
    }

    @Inject(method={"getUseAnimation(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemUseAnimation;"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$getUseAction(ItemStack stack, CallbackInfoReturnable<ItemUseAnimation> cir) {
        if (this instanceof CompatItemProvider) {
            CompatItemProvider provider = (CompatItemProvider)((Object)this);
            ExtendItemProvider.Options options = new ExtendItemProvider.Options();
            CompatUseAction returnValue = provider.getUseAction(new UseActionArgs(stack), options);
            if (options.cancel) {
                cir.setReturnValue((Object)returnValue.get());
            }
        }
    }

    @Inject(method={"inventoryTick(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;IZ)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected, CallbackInfo ci) {
        if (!ItemEventRegistry.INVENTORY_TICK.isEmpty()) {
            int maxPriority;
            for (int p = maxPriority = ItemEventRegistry.INVENTORY_TICK.getMaxPriority(); p >= 0; --p) {
                for (InventoryTickTask listener : ItemEventRegistry.INVENTORY_TICK.getListenersAsList(p)) {
                    listener.inventoryTick(new InventoryTickEvent(stack, world, entity, slot, selected));
                }
            }
        }
        if (this instanceof CompatItemProvider) {
            CompatItemProvider provider = (CompatItemProvider)((Object)this);
            ExtendItemProvider.Options options = new ExtendItemProvider.Options();
            provider.inventoryTick(new InventoryTickEvent(stack, world, entity, slot, selected), options);
            if (options.cancel) {
                ci.cancel();
            }
        }
    }
}

