/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.item;

import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.pitan76.mcpitanlib.api.enchantment.CompatEnchantment;
import net.pitan76.mcpitanlib.api.item.stack.LoreUtil;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.CustomDataUtil;
import net.pitan76.mcpitanlib.api.util.EnchantmentUtil;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.ItemUtil;
import net.pitan76.mcpitanlib.api.util.NbtUtil;
import net.pitan76.mcpitanlib.midohra.item.ItemWrapper;
import org.jetbrains.annotations.Nullable;

public class ItemStack {
    private final class_1799 stack;
    public static final ItemStack EMPTY = new ItemStack(ItemStackUtil.empty());

    protected ItemStack(class_1799 stack) {
        this.stack = stack;
    }

    public static ItemStack of(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return EMPTY;
        }
        return new ItemStack(stack);
    }

    public static ItemStack of(class_1935 item) {
        return new Builder().item(item).build();
    }

    public static ItemStack of(class_1935 item, int count) {
        return new Builder().item(item).count(count).build();
    }

    public static ItemStack empty() {
        return EMPTY;
    }

    public int getCount() {
        return this.stack.method_7947();
    }

    public void setCount(int count) {
        this.stack.method_7939(count);
    }

    public class_2487 getCustomNbt() {
        return CustomDataUtil.getNbt(this.stack);
    }

    public void setCustomNbt(class_2487 nbt) {
        CustomDataUtil.setNbt(this.stack, nbt);
    }

    public void removeCustomNbt() {
        CustomDataUtil.remove(this.stack);
    }

    public boolean hasCustomNbt() {
        return CustomDataUtil.hasNbt(this.stack);
    }

    public boolean isEmpty() {
        return this.stack.method_7960();
    }

    public CompatIdentifier getItemId() {
        return ItemUtil.toCompatID(this.stack.method_7909());
    }

    public ItemStack copy() {
        return new ItemStack(this.stack.method_7972());
    }

    public ItemStack copyWithCount(int count) {
        return new ItemStack(this.stack.method_46651(count));
    }

    public Map<CompatEnchantment, Integer> getEnchantments(@Nullable class_1937 world) {
        return EnchantmentUtil.getEnchantment(this.stack, world);
    }

    public void setEnchantments(Map<CompatEnchantment, Integer> enchantments, @Nullable class_1937 world) {
        EnchantmentUtil.setEnchantment(this.stack, enchantments, world);
    }

    public int getMaxCount() {
        return ItemStackUtil.getMaxCount(this.stack);
    }

    public boolean hasLore() {
        return LoreUtil.hasLore(this.stack);
    }

    public List<class_2561> getLore() {
        return LoreUtil.getLore(this.stack);
    }

    public List<String> getLoreAsStringList() {
        return LoreUtil.getLoreAsStringList(this.stack);
    }

    public void setLore(List<class_2561> lore) {
        LoreUtil.setLore(this.stack, lore);
    }

    public void setLoreString(List<String> lore) {
        LoreUtil.setLoreStringList(this.stack, lore);
    }

    public void setLore(String lore) {
        LoreUtil.setLore(this.stack, lore);
    }

    @Deprecated
    public class_1799 toMinecraft() {
        return this.stack;
    }

    public ItemWrapper getItem() {
        if (this.isEmpty()) {
            return ItemWrapper.of();
        }
        return ItemWrapper.of(this.getRawItem());
    }

    public class_1792 getRawItem() {
        return ItemStackUtil.getItem(this.stack);
    }

    public String toString() {
        return this.stack.toString();
    }

    public static class Builder {
        protected CompatIdentifier id;
        protected int count = 1;
        protected class_2487 nbt = NbtUtil.create();

        public Builder item(CompatIdentifier id) {
            this.id = id;
            return this;
        }

        public Builder item(class_1935 item) {
            this.id = ItemUtil.toCompatID(item.method_8389());
            return this;
        }

        public Builder count(int count) {
            this.count = count;
            return this;
        }

        public Builder nbt(class_2487 nbt) {
            this.nbt = nbt;
            return this;
        }

        public ItemStack build() {
            class_1799 stack = new class_1799((class_1935)ItemUtil.fromId(this.id), this.count);
            CustomDataUtil.setNbt(stack, this.nbt);
            return new ItemStack(stack);
        }
    }
}

