/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.client.gui.screen;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.pitan76.mcpitanlib.api.client.gui.widget.CompatibleTexturedButtonWidget;
import net.pitan76.mcpitanlib.api.client.render.DrawObjectDM;
import net.pitan76.mcpitanlib.api.client.render.handledscreen.DrawBackgroundArgs;
import net.pitan76.mcpitanlib.api.client.render.handledscreen.DrawForegroundArgs;
import net.pitan76.mcpitanlib.api.client.render.handledscreen.DrawMouseoverTooltipArgs;
import net.pitan76.mcpitanlib.api.client.render.handledscreen.KeyEventArgs;
import net.pitan76.mcpitanlib.api.client.render.handledscreen.RenderArgs;
import net.pitan76.mcpitanlib.api.client.render.screen.RenderBackgroundTextureArgs;
import net.pitan76.mcpitanlib.api.text.TextComponent;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.IdentifierUtil;
import net.pitan76.mcpitanlib.api.util.client.ClientUtil;
import net.pitan76.mcpitanlib.api.util.client.RenderUtil;
import net.pitan76.mcpitanlib.api.util.client.ScreenUtil;
import net.pitan76.mcpitanlib.core.datafixer.Pair;

public abstract class SimpleHandledScreen<S extends AbstractContainerMenu>
extends AbstractContainerScreen<S> {
    public int width;
    public int height;
    public int backgroundWidth;
    public int backgroundHeight;
    public int x;
    public int y;
    public S handler;
    public Font textRenderer;
    public ItemRenderer itemRenderer;
    public Component title;
    public Minecraft client;

    public SimpleHandledScreen(S handler, Inventory inventory, Component title) {
        super(handler, inventory, title);
        this.fixScreen();
        this.handler = handler;
        this.title = title;
    }

    @Deprecated
    public S m_6262_() {
        return this.getScreenHandlerOverride();
    }

    public S getScreenHandlerOverride() {
        return (S)super.m_6262_();
    }

    public <T extends GuiEventListener & Renderable> T addDrawableChild_compatibility(T drawableElement) {
        return (T)super.m_142416_(drawableElement);
    }

    public <T extends GuiEventListener & NarratableEntry> T addSelectableChild_compatibility(T selectableElement) {
        return (T)super.m_7787_(selectableElement);
    }

    public CompatibleTexturedButtonWidget addDrawableCTBW(CompatibleTexturedButtonWidget widget) {
        return this.addDrawableChild_compatibility(widget);
    }

    @Deprecated
    protected void m_7286_(GuiGraphics context, float delta, int mouseX, int mouseY) {
        DrawObjectDM drawObjectDM = new DrawObjectDM(context, (Screen)this);
        this.drawBackgroundOverride(new DrawBackgroundArgs(drawObjectDM, delta, mouseX, mouseY));
    }

    public abstract void drawBackgroundOverride(DrawBackgroundArgs var1);

    @Deprecated
    protected void m_280003_(GuiGraphics context, int mouseX, int mouseY) {
        DrawObjectDM drawObjectDM = new DrawObjectDM(context, (Screen)this);
        this.drawForegroundOverride(new DrawForegroundArgs(drawObjectDM, mouseX, mouseY));
    }

    protected void drawForegroundOverride(DrawForegroundArgs args) {
        super.m_280003_(args.drawObjectDM.getContext(), args.mouseX, args.mouseY);
    }

    public void callDrawTexture(DrawObjectDM drawObjectDM, ResourceLocation texture, int x, int y, int u, int v, int width, int height) {
        drawObjectDM.getContext().m_280218_(texture, x, y, u, v, width, height);
    }

    public void callDrawTexture(DrawObjectDM drawObjectDM, CompatIdentifier texture, int x, int y, int u, int v, int width, int height) {
        this.callDrawTexture(drawObjectDM, texture.toMinecraft(), x, y, u, v, width, height);
    }

    @Deprecated
    public void callRenderBackground(DrawObjectDM drawObjectDM) {
        this.callRenderBackground(new RenderArgs(drawObjectDM, 0, 0, 0.0f));
    }

    public void callRenderBackground(RenderArgs args) {
        super.m_280273_(args.drawObjectDM.getContext());
    }

    public void callDrawMouseoverTooltip(DrawMouseoverTooltipArgs args) {
        super.m_280072_(args.drawObjectDM.getContext(), args.mouseX, args.mouseY);
    }

    public void renderOverride(RenderArgs args) {
        super.m_88315_(args.drawObjectDM.getContext(), args.mouseX, args.mouseY, args.delta);
    }

    public void resizeOverride(Minecraft client, int width, int height) {
    }

    public void initOverride() {
    }

    @Deprecated
    protected void m_7856_() {
        super.m_7856_();
        this.fixScreen();
        this.initOverride();
    }

    @Deprecated
    public void m_6574_(Minecraft client, int width, int height) {
        super.m_6574_(client, width, height);
        this.fixScreen();
        this.resizeOverride(client, width, height);
    }

    public void fixScreen() {
        this.backgroundWidth = this.getBackgroundWidth();
        this.backgroundHeight = this.getBackgroundHeight();
        this.x = this.f_97735_;
        this.y = this.f_97736_;
        this.textRenderer = this.f_96547_;
        this.itemRenderer = Minecraft.m_91087_().m_91291_();
        this.width = this.f_96543_;
        this.height = this.f_96544_;
        this.client = this.f_96541_ == null ? Minecraft.m_91087_() : this.f_96541_;
    }

    public void setX(int x) {
        this.x = x;
        this.f_97735_ = x;
    }

    public void setY(int y) {
        this.y = y;
        this.f_97736_ = y;
    }

    public void setTextRenderer(Font textRenderer) {
        this.textRenderer = textRenderer;
        this.f_96547_ = textRenderer;
    }

    public void setItemRenderer(ItemRenderer itemRenderer) {
        this.itemRenderer = itemRenderer;
    }

    public void setWidth(int width) {
        this.width = width;
        this.f_96543_ = width;
    }

    public void setBackgroundWidth(int backgroundWidth) {
        this.backgroundWidth = backgroundWidth;
        this.f_97726_ = backgroundWidth;
    }

    public void setBackgroundHeight(int backgroundHeight) {
        this.backgroundHeight = backgroundHeight;
        this.f_97727_ = backgroundHeight;
    }

    public void setHeight(int height) {
        this.height = height;
        this.f_96544_ = height;
    }

    public int getBackgroundWidth() {
        return this.f_97726_;
    }

    public int getBackgroundHeight() {
        return this.f_97727_;
    }

    @Deprecated
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        DrawObjectDM drawObjectDM = new DrawObjectDM(context, (Screen)this);
        this.renderOverride(new RenderArgs(drawObjectDM, mouseX, mouseY, delta));
    }

    public boolean keyReleased(KeyEventArgs args) {
        return super.m_7920_(args.keyCode, args.scanCode, args.modifiers);
    }

    public boolean keyPressed(KeyEventArgs args) {
        return super.m_7933_(args.keyCode, args.scanCode, args.modifiers);
    }

    public void renderBackgroundTexture(RenderBackgroundTextureArgs args) {
        if (this.getBackgroundTexture() == null) {
            super.m_280039_(args.drawObjectDM.getContext());
            return;
        }
        RenderUtil.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.callDrawTexture(args.drawObjectDM, this.getBackgroundTexture(), 0, 0, 0, 0, this.width, this.height);
    }

    @Deprecated
    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return this.keyReleased(new KeyEventArgs(keyCode, scanCode, modifiers));
    }

    @Deprecated
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.keyPressed(new KeyEventArgs(keyCode, scanCode, modifiers));
    }

    @Deprecated
    public void m_280039_(GuiGraphics context) {
        this.renderBackgroundTexture(new RenderBackgroundTextureArgs(new DrawObjectDM(context, (Screen)this), 0));
    }

    public void closeOverride() {
        super.m_7379_();
    }

    public void removedOverride() {
        super.m_7861_();
    }

    public void m_7379_() {
        this.closeOverride();
    }

    public void m_7861_() {
        this.removedOverride();
    }

    public ResourceLocation getBackgroundTexture() {
        return IdentifierUtil.from(this.getCompatBackgroundTexture());
    }

    public CompatIdentifier getCompatBackgroundTexture() {
        return null;
    }

    public void setTitleX(int x) {
        this.f_97728_ = x;
    }

    public void setTitleY(int y) {
        this.f_97729_ = y;
    }

    public void setTitlePos(int x, int y) {
        this.setTitleX(x);
        this.setTitleY(y);
    }

    public void setTitleXCenter() {
        if (this.textRenderer == null) {
            this.textRenderer = ClientUtil.getTextRenderer();
        }
        this.setTitleX(this.backgroundWidth / 2 - this.textRenderer.m_92852_((FormattedText)this.title) / 2);
    }

    public int getTitleX() {
        return this.f_97728_;
    }

    public int getTitleY() {
        return this.f_97729_;
    }

    public void drawText(DrawObjectDM drawObjectDM, Component text, int x, int y, int color) {
        ScreenUtil.RendererUtil.drawText(this.textRenderer, drawObjectDM, text, x, y, color);
    }

    public void drawText(DrawObjectDM drawObjectDM, TextComponent text, int x, int y, int color) {
        ScreenUtil.RendererUtil.drawText(this.textRenderer, drawObjectDM, text, x, y, color);
    }

    public void drawText(DrawObjectDM drawObjectDM, Component text, int x, int y) {
        ScreenUtil.RendererUtil.drawText(this.textRenderer, drawObjectDM, text, x, y);
    }

    public void drawText(DrawObjectDM drawObjectDM, TextComponent text, int x, int y) {
        ScreenUtil.RendererUtil.drawText(this.textRenderer, drawObjectDM, text, x, y);
    }

    @Deprecated
    public Component m_96636_() {
        return this.callGetTitle();
    }

    public Component callGetTitle() {
        return super.m_96636_();
    }

    public Pair<Integer, Integer> getTitlePosP() {
        return new Pair<Integer, Integer>(this.getTitleX(), this.getTitleY());
    }

    public int getPlayerInvTitleX() {
        return this.f_97730_;
    }

    public int getPlayerInvTitleY() {
        return this.f_97731_;
    }

    public void setPlayerInvTitleX(int x) {
        this.f_97730_ = x;
    }

    public void setPlayerInvTitleY(int y) {
        this.f_97731_ = y;
    }

    public void setPlayerInvTitle(int x, int y) {
        this.setPlayerInvTitleX(x);
        this.setPlayerInvTitleY(y);
    }

    public Font callGetTextRenderer() {
        if (this.textRenderer != null) {
            return this.textRenderer;
        }
        if (this.f_96547_ != null) {
            return this.f_96547_;
        }
        return ClientUtil.getTextRenderer();
    }

    public ItemRenderer callGetItemRenderer() {
        if (this.itemRenderer != null) {
            return this.itemRenderer;
        }
        return ClientUtil.getItemRenderer();
    }

    public Component getPlayerInvTitle() {
        return this.f_169604_;
    }
}

