/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.network.v2;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.network.PacketByteUtil;
import net.pitan76.mcpitanlib.api.network.v2.args.ServerReceiveEvent;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.midohra.network.CompatPacketByteBuf;

public class ServerNetworking {
    public static void send(ServerPlayer serverPlayerEntity, CompatIdentifier id, FriendlyByteBuf buf) {
        net.pitan76.mcpitanlib.api.network.ServerNetworking.send(serverPlayerEntity, id.toMinecraft(), buf);
    }

    public static void sendByServerPlayerEntity(Iterable<ServerPlayer> players, CompatIdentifier id, FriendlyByteBuf buf) {
        net.pitan76.mcpitanlib.api.network.ServerNetworking.send(players, id.toMinecraft(), buf);
    }

    public static void send(Player player, CompatIdentifier id, FriendlyByteBuf buf) {
        Optional<ServerPlayer> optional = player.getServerPlayer();
        if (optional.isEmpty()) {
            return;
        }
        ServerNetworking.send(optional.get(), id, buf);
    }

    public static void send(Iterable<Player> players, CompatIdentifier id, FriendlyByteBuf buf) {
        ArrayList<ServerPlayer> list = new ArrayList<ServerPlayer>();
        for (Player player : players) {
            Optional<ServerPlayer> optional = player.getServerPlayer();
            optional.ifPresent(list::add);
        }
        ServerNetworking.sendByServerPlayerEntity(list, id, buf);
    }

    public static void sendAll(MinecraftServer server, CompatIdentifier id, FriendlyByteBuf buf) {
        net.pitan76.mcpitanlib.api.network.ServerNetworking.sendAll(server, id.toMinecraft(), buf);
    }

    public static void sendAll(Level world, CompatIdentifier id, FriendlyByteBuf buf) {
        ServerNetworking.sendAll(world.m_7654_(), id, buf);
    }

    public static void registerReceiver(CompatIdentifier id, Consumer<ServerReceiveEvent> consumer) {
        net.pitan76.mcpitanlib.api.network.ServerNetworking.registerReceiver(id.toMinecraft(), (MinecraftServer server, ServerPlayer player, FriendlyByteBuf buf) -> consumer.accept(new ServerReceiveEvent(server, player, buf)));
    }

    public static void send(ServerPlayer serverPlayerEntity, CompatIdentifier id, CompatPacketByteBuf buf) {
        ServerNetworking.send(serverPlayerEntity, id, buf.getRaw());
    }

    public static void send(Player player, CompatIdentifier id, CompatPacketByteBuf buf) {
        ServerNetworking.send(player, id, buf.getRaw());
    }

    public static void send(Iterable<Player> players, CompatIdentifier id, CompatPacketByteBuf buf) {
        ServerNetworking.send(players, id, buf.getRaw());
    }

    public static void sendAll(MinecraftServer server, CompatIdentifier id, CompatPacketByteBuf buf) {
        ServerNetworking.sendAll(server, id, buf.getRaw());
    }

    public static void sendAll(Level world, CompatIdentifier id, CompatPacketByteBuf buf) {
        ServerNetworking.sendAll(world.m_7654_(), id, buf.getRaw());
    }

    public static void send(ServerPlayer serverPlayerEntity, CompatIdentifier id) {
        ServerNetworking.send(serverPlayerEntity, id, PacketByteUtil.create());
    }

    public static void send(Player player, CompatIdentifier id) {
        ServerNetworking.send(player, id, PacketByteUtil.create());
    }

    public static void send(Iterable<Player> players, CompatIdentifier id) {
        ServerNetworking.send(players, id, PacketByteUtil.create());
    }

    public static void sendAll(MinecraftServer server, CompatIdentifier id) {
        ServerNetworking.sendAll(server, id, PacketByteUtil.create());
    }

    public static void sendAll(Level world, CompatIdentifier id) {
        ServerNetworking.sendAll(world.m_7654_(), id, PacketByteUtil.create());
    }
}

