/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.registry;

import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.pitan76.mcpitanlib.MCPitanLib;
import net.pitan76.mcpitanlib.api.block.CompatibleMaterial;
import net.pitan76.mcpitanlib.api.block.v2.CompatibleBlockSettings;
import net.pitan76.mcpitanlib.api.gui.ExtendedScreenHandlerTypeBuilder;
import net.pitan76.mcpitanlib.api.item.CreativeTabBuilder;
import net.pitan76.mcpitanlib.api.item.CreativeTabManager;
import net.pitan76.mcpitanlib.api.item.v2.CompatibleItemSettings;
import net.pitan76.mcpitanlib.api.registry.WorldGenRegistry;
import net.pitan76.mcpitanlib.api.registry.result.RegistryResult;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.block.BlockUtil;
import net.pitan76.mcpitanlib.api.util.item.ItemUtil;
import net.pitan76.mcpitanlib.core.registry.FuelRegistry;
import net.pitan76.mcpitanlib.core.registry.MCPLRegistry;
import net.pitan76.mcpitanlib.core.registry.MCPLRegistry1_20;

public class CompatRegistry {
    protected final MCPLRegistry mcplr;
    protected final MCPLRegistry1_20 mcplr1_20;
    protected final WorldGenRegistry worldGenRegistry;
    protected String MOD_ID;

    @Deprecated
    public CompatRegistry(String MOD_ID) {
        this.mcplr = new MCPLRegistry(MOD_ID);
        this.mcplr1_20 = new MCPLRegistry1_20(this.mcplr, MOD_ID);
        this.worldGenRegistry = new WorldGenRegistry(MOD_ID);
        this.MOD_ID = MOD_ID;
    }

    public static CompatRegistry createRegistry(String MOD_ID) {
        return new CompatRegistry(MOD_ID);
    }

    public static CompatRegistry create(String MOD_ID) {
        return CompatRegistry.createRegistry(MOD_ID);
    }

    public RegistryResult<Item> registerItem(ResourceLocation id, Supplier<Item> supplier) {
        if (MCPitanLib.isItemBlackListed(id)) {
            supplier = () -> ItemUtil.create(CompatibleItemSettings.of(CompatIdentifier.fromMinecraft(id)));
        }
        RegistrySupplier<Item> registrySupplier = this.mcplr.registryItem(id, supplier);
        CreativeTabManager.register(id);
        return new RegistryResult<Item>(registrySupplier);
    }

    public RegistryResult<Block> registerBlock(ResourceLocation id, Supplier<Block> supplier) {
        if (MCPitanLib.isBlockBlackListed(id)) {
            supplier = () -> BlockUtil.create(CompatibleBlockSettings.of(CompatIdentifier.fromMinecraft(id), CompatibleMaterial.STONE));
        }
        return new RegistryResult<Block>(this.mcplr.registryBlock(id, supplier));
    }

    public RegistryResult<MenuType<?>> registerScreenHandlerType(ResourceLocation id, Supplier<MenuType<?>> supplier) {
        return new RegistryResult(this.mcplr.registryScreenHandlerType(id, supplier));
    }

    @Deprecated
    public RegistryResult<MenuType<?>> registerExtendedScreenHandlerType(ResourceLocation id, Supplier<ExtendedScreenHandlerTypeBuilder<?>> supplier) {
        return this.registerScreenHandlerType(id, () -> ((ExtendedScreenHandlerTypeBuilder)supplier.get()).build());
    }

    public RegistryResult<MenuType<?>> registerMenu(ResourceLocation id, Supplier<MenuType<?>> supplier) {
        return this.registerScreenHandlerType(id, supplier);
    }

    public RegistryResult<BlockEntityType<?>> registerBlockEntityType(ResourceLocation id, Supplier<BlockEntityType<?>> supplier) {
        return new RegistryResult(this.mcplr.registryBlockEntityType(id, supplier));
    }

    public RegistryResult<EntityType<?>> registerEntity(ResourceLocation id, Supplier<EntityType<?>> supplier) {
        return new RegistryResult(this.mcplr.registryEntityType(id, supplier));
    }

    @Deprecated
    public RegistryResult<SoundEvent> registerSoundEvent(ResourceLocation id, Supplier<SoundEvent> supplier) {
        return new RegistryResult<SoundEvent>(this.mcplr.registrySoundEvent(id, supplier));
    }

    public RegistryResult<SoundEvent> registerSoundEvent(ResourceLocation id) {
        return this.registerSoundEvent(id, () -> SoundEvent.m_262824_((ResourceLocation)id));
    }

    public RegistryResult<SoundEvent> registerSoundEvent(ResourceLocation id, float distanceToTravel) {
        return this.registerSoundEvent(id, () -> SoundEvent.m_262856_((ResourceLocation)id, (float)distanceToTravel));
    }

    public RegistryResult<Fluid> registerFluid(ResourceLocation id, Supplier<Fluid> supplier) {
        return new RegistryResult<Fluid>(this.mcplr.registryFluid(id, supplier));
    }

    public RegistryResult<ParticleType<?>> registerParticleType(ResourceLocation id, Supplier<ParticleType<?>> supplier) {
        return new RegistryResult(this.mcplr.registryParticleType(id, supplier));
    }

    public RegistryResult<Enchantment> registerEnchantment(ResourceLocation id, Supplier<Enchantment> supplier) {
        return new RegistryResult<Enchantment>(this.mcplr.registryEnchantment(id, supplier));
    }

    public RegistryResult<MobEffect> registerStatusEffect(ResourceLocation id, Supplier<MobEffect> supplier) {
        return new RegistryResult<MobEffect>(this.mcplr.registryStatusEffect(id, supplier));
    }

    public RegistryResult<CreativeModeTab> registerItemGroup(ResourceLocation id, Supplier<CreativeModeTab> supplier) {
        return new RegistryResult<CreativeModeTab>(this.mcplr1_20.registryItemGroup(id, supplier));
    }

    public RegistryResult<CreativeModeTab> registerItemGroup(ResourceLocation id, CreativeTabBuilder builder) {
        return new RegistryResult<CreativeModeTab>(this.mcplr1_20.registryItemGroup(id, builder));
    }

    public RegistryResult<CreativeModeTab> registerItemGroup(CreativeTabBuilder builder) {
        return this.registerItemGroup(builder.getIdentifier(), builder);
    }

    public static void registerFuel(int time, ItemLike ... item) {
        FuelRegistry.register(time, item);
    }

    public void allRegister() {
        this.mcplr.allRegister1_16();
        this.mcplr1_20.register();
        CreativeTabManager.allRegister();
    }

    @Deprecated
    public MCPLRegistry getMcplr() {
        return this.mcplr;
    }

    @Deprecated
    public MCPLRegistry1_20 getMcplr1_20() {
        return this.mcplr1_20;
    }

    public String getNamespace() {
        return this.MOD_ID;
    }
}

