/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.pitan76.mcpitanlib.api.event.nbt.NbtRWArgs;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;

public class InventoryUtil {
    public static boolean insertItem(ItemStack insertStack, NonNullList<ItemStack> inventory) {
        return InventoryUtil.insertItem(insertStack, inventory, false);
    }

    public static boolean insertItem(ItemStack insertStack, NonNullList<ItemStack> inventory, boolean test) {
        boolean isInserted = false;
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = (ItemStack)inventory.get(i);
            if (stack.m_41619_()) {
                if (!test) {
                    inventory.set(i, (Object)insertStack);
                }
                isInserted = true;
                break;
            }
            if (!InventoryUtil.canMergeItems(stack, insertStack)) continue;
            int j = insertStack.m_41613_();
            if (!test) {
                stack.m_41769_(j);
            }
            isInserted = j > 0;
            break;
        }
        return isInserted;
    }

    public static boolean canMergeItems(ItemStack first, ItemStack second) {
        if (!first.m_150930_(second.m_41720_())) {
            return false;
        }
        if (first.m_41773_() != second.m_41773_()) {
            return false;
        }
        if (first.m_41613_() + second.m_41613_() > first.m_41741_()) {
            return false;
        }
        return ItemStackUtil.areNbtOrComponentEqual(first, second);
    }

    public static CompoundTag writeNbt(NbtRWArgs args, CompoundTag nbt, NonNullList<ItemStack> stacks, boolean setIfEmpty) {
        return ContainerHelper.m_18976_((CompoundTag)nbt, stacks, (boolean)setIfEmpty);
    }

    public static void readNbt(NbtRWArgs args, CompoundTag nbt, NonNullList<ItemStack> stacks) {
        ContainerHelper.m_18980_((CompoundTag)nbt, stacks);
    }

    public static CompoundTag writeNbt(NbtRWArgs args, NonNullList<ItemStack> stacks, boolean setIfEmpty) {
        return ContainerHelper.m_18976_((CompoundTag)args.getNbt(), stacks, (boolean)setIfEmpty);
    }

    public static CompoundTag writeNbt(NbtRWArgs args, NonNullList<ItemStack> stacks) {
        return InventoryUtil.writeNbt(args, stacks, true);
    }

    public static void readNbt(NbtRWArgs args, NonNullList<ItemStack> stacks) {
        ContainerHelper.m_18980_((CompoundTag)args.getNbt(), stacks);
    }

    public static void readNbt(CompatRegistryLookup registryLookup, CompoundTag nbt, NonNullList<ItemStack> stacks) {
        ContainerHelper.m_18980_((CompoundTag)nbt, stacks);
    }

    public static CompoundTag writeNbt(CompatRegistryLookup registryLookup, CompoundTag nbt, NonNullList<ItemStack> stacks, boolean setIfEmpty) {
        return ContainerHelper.m_18976_((CompoundTag)nbt, stacks, (boolean)setIfEmpty);
    }

    public static CompoundTag writeNbt(CompatRegistryLookup registryLookup, CompoundTag nbt, NonNullList<ItemStack> stacks) {
        return InventoryUtil.writeNbt(registryLookup, nbt, stacks, true);
    }

    @Deprecated
    public static CompoundTag writeNbt(Level world, CompoundTag nbt, NonNullList<ItemStack> stacks) {
        return InventoryUtil.writeNbt(world, nbt, true, stacks);
    }

    @Deprecated
    public static CompoundTag writeNbt(Level world, CompoundTag nbt, boolean setIfEmpty, NonNullList<ItemStack> stacks) {
        return ContainerHelper.m_18976_((CompoundTag)nbt, stacks, (boolean)setIfEmpty);
    }

    @Deprecated
    public static void readNbt(Level world, CompoundTag nbt, NonNullList<ItemStack> stacks) {
        ContainerHelper.m_18980_((CompoundTag)nbt, stacks);
    }

    public static SimpleContainer createSimpleInventory(int size) {
        return new SimpleContainer(size);
    }

    public static void copyToInv(NonNullList<ItemStack> from, Container to) {
        for (int i = 0; i < from.size(); ++i) {
            to.m_6836_(i, (ItemStack)from.get(i));
        }
    }

    public static void copyToList(Container from, NonNullList<ItemStack> to) {
        for (int i = 0; i < from.m_6643_(); ++i) {
            to.set(i, (Object)from.m_8020_(i));
        }
    }

    public static int getSize(Container inventory) {
        return inventory.m_6643_();
    }

    public static ItemStack getStack(Container inventory, int slot) {
        return inventory.m_8020_(slot);
    }

    public static void setStack(Container inventory, int slot, ItemStack stack) {
        inventory.m_6836_(slot, stack);
    }

    public static boolean isEmpty(Container inventory) {
        return inventory.m_7983_();
    }

    public static ItemStack removeStack(Container inventory, int slot) {
        return inventory.m_8016_(slot);
    }

    public static ItemStack removeStack(Container inventory, int slot, int amount) {
        return inventory.m_7407_(slot, amount);
    }

    public static void clear(Container inventory) {
        inventory.m_6211_();
    }

    public static void markDirty(Container inventory) {
        inventory.m_6596_();
    }
}

