/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.client.event.listener;

import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_9974;
import net.pitan76.mcpitanlib.api.util.VoxelShapeUtil;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public interface WorldRenderContext {
    public class_761 getWorldRenderer();

    public class_4587 getMatrixStack();

    public float getTickDelta();

    public class_4184 getCamera();

    public class_757 getGameRenderer();

    public class_765 getLightmapTextureManager();

    @Deprecated
    public Matrix4f getProjectionMatrix();

    public class_638 getWorld();

    @Deprecated
    public boolean isAdvancedTranslucency();

    @Nullable
    public class_4597 getConsumers();

    @Nullable
    public class_4604 getFrustum();

    default public class_239 getHitResult() {
        return class_310.method_1551().field_1765;
    }

    default public Optional<class_2680> getBlockState() {
        return Optional.ofNullable(this.getWorld().method_8320((class_2338)this.getBlockPos().orElse(null)));
    }

    default public Optional<class_2338> getBlockPos() {
        return Optional.ofNullable(((class_3965)this.getHitResult()).method_17777());
    }

    default public boolean isBlockType() {
        return this.getHitResultType() == class_239.class_240.field_1332;
    }

    default public class_239.class_240 getHitResultType() {
        return this.getHitResult().method_17783();
    }

    default public Optional<class_265> getOutlineShape() {
        return this.getBlockState().map(blockState -> blockState.method_26218((class_1922)this.getWorld(), (class_2338)this.getBlockPos().orElse(null)));
    }

    default public void push() {
        this.getMatrixStack().method_22903();
    }

    default public void translate(double x, double y, double z) {
        this.getMatrixStack().method_22904(x, y, z);
    }

    default public void pop() {
        this.getMatrixStack().method_22909();
    }

    default public Optional<class_4588> getVertexConsumer() {
        if (this.getConsumers() == null) {
            return Optional.empty();
        }
        return Optional.of(Objects.requireNonNull(this.getConsumers()).getBuffer(class_1921.method_23594()));
    }

    default public void drawBox(float red, float green, float blue, float alpha) {
        Optional<class_265> outlineShape = this.getOutlineShape();
        if (!outlineShape.isPresent()) {
            return;
        }
        this.drawBox(VoxelShapeUtil.getBoundingBox(outlineShape.get()), red, green, blue, alpha);
    }

    default public void drawBox(class_238 box, float red, float green, float blue, float alpha) {
        Optional<class_4588> vertexConsumer = this.getVertexConsumer();
        if (!vertexConsumer.isPresent()) {
            return;
        }
        class_9974.method_62295((class_4587)this.getMatrixStack(), (class_4588)vertexConsumer.get(), (class_238)box, (float)red, (float)green, (float)blue, (float)alpha);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface BlockOutlineContext {
        @Deprecated
        public class_4588 vertexConsumer();

        public class_1297 entity();

        public double cameraX();

        public double cameraY();

        public double cameraZ();

        public class_2338 blockPos();

        public class_2680 blockState();
    }
}

