/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.transfer.fluid.v1.fabric;

import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.SingleFluidStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.pitan76.mcpitanlib.api.event.nbt.ReadNbtArgs;
import net.pitan76.mcpitanlib.api.event.nbt.WriteNbtArgs;
import net.pitan76.mcpitanlib.api.transfer.fluid.v1.IFluidStorage;
import net.pitan76.mcpitanlib.api.transfer.fluid.v1.IFluidVariant;
import net.pitan76.mcpitanlib.api.transfer.fluid.v1.fabric.FabricFluidVariant;

public class FabricFluidStorage
implements IFluidStorage {
    public final SingleFluidStorage storage;

    public FabricFluidStorage(SingleFluidStorage storage) {
        this.storage = storage;
    }

    @Override
    public long getAmount() {
        return this.storage.getAmount();
    }

    @Override
    public long getCapacity() {
        return this.storage.getCapacity();
    }

    @Override
    public IFluidVariant getResource() {
        return new FabricFluidVariant((FluidVariant)this.storage.getResource());
    }

    @Override
    public void setResource(IFluidVariant variant) {
        this.storage.variant = ((FabricFluidVariant)variant).raw;
    }

    @Override
    public boolean isResourceBlank() {
        return this.storage.isResourceBlank();
    }

    @Override
    public long insert(IFluidVariant variant, long maxAmount, boolean simulate) {
        if (simulate) {
            return this.storage.insert((TransferVariant)((FabricFluidVariant)variant).raw, maxAmount, (TransactionContext)Transaction.openOuter());
        }
        long inserted = 0L;
        try (Transaction transaction = Transaction.openOuter();){
            transaction.commit();
        }
        return inserted += this.storage.insert((TransferVariant)((FabricFluidVariant)variant).raw, maxAmount, (TransactionContext)transaction);
    }

    @Override
    public long extract(IFluidVariant variant, long maxAmount, boolean simulate) {
        if (simulate) {
            return this.storage.extract((TransferVariant)((FabricFluidVariant)variant).raw, maxAmount, (TransactionContext)Transaction.openOuter());
        }
        long extracted = 0L;
        try (Transaction transaction = Transaction.openOuter();){
            transaction.commit();
        }
        return extracted += this.storage.extract((TransferVariant)((FabricFluidVariant)variant).raw, maxAmount, (TransactionContext)transaction);
    }

    @Override
    public void writeNbt(WriteNbtArgs args) {
        this.storage.writeNbt(args.nbt);
    }

    @Override
    public void readNbt(ReadNbtArgs args) {
        this.storage.readNbt(args.nbt);
    }
}

