/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.entity;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.pitan76.mcpitanlib.api.entity.effect.CompatStatusEffect;
import net.pitan76.mcpitanlib.api.entity.effect.CompatStatusEffectInstance;
import net.pitan76.mcpitanlib.api.gui.ExtendedNamedScreenHandlerFactory;
import net.pitan76.mcpitanlib.api.item.CompatFoodComponent;
import net.pitan76.mcpitanlib.api.sound.CompatSoundCategory;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvent;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.NbtUtil;
import net.pitan76.mcpitanlib.api.util.ScreenHandlerUtil;
import net.pitan76.mcpitanlib.core.player.ItemCooldown;
import net.pitan76.mcpitanlib.midohra.item.ItemStack;
import net.pitan76.mcpitanlib.midohra.world.World;

public class Player {
    private final net.minecraft.world.entity.player.Player entity;
    public ItemCooldown itemCooldown = new ItemCooldown(this);

    public net.minecraft.world.entity.player.Player getEntity() {
        return this.entity;
    }

    public net.minecraft.world.entity.player.Player getPlayerEntity() {
        return this.getEntity();
    }

    public Player(net.minecraft.world.entity.player.Player playerEntity) {
        this.entity = playerEntity;
    }

    public Inventory getInv() {
        return this.getEntity().getInventory();
    }

    public Inventory getInventory() {
        return this.getInv();
    }

    public NonNullList<net.minecraft.world.item.ItemStack> getArmor() {
        NonNullList stacks = NonNullList.withSize((int)4, (Object)net.minecraft.world.item.ItemStack.EMPTY);
        stacks.set(0, (Object)this.getInv().getItem(36));
        stacks.set(1, (Object)this.getInv().getItem(37));
        stacks.set(2, (Object)this.getInv().getItem(38));
        stacks.set(3, (Object)this.getInv().getItem(39));
        return stacks;
    }

    public NonNullList<net.minecraft.world.item.ItemStack> getMain() {
        return this.getInv().getNonEquipmentItems();
    }

    public NonNullList<net.minecraft.world.item.ItemStack> getOffHand() {
        NonNullList stacks = NonNullList.withSize((int)1, (Object)net.minecraft.world.item.ItemStack.EMPTY);
        stacks.set(0, (Object)this.getInv().getItem(40));
        return stacks;
    }

    public int getSelectSlot() {
        return this.getInv().getSelectedSlot();
    }

    public int getInvSize() {
        return this.getInv().getContainerSize();
    }

    public OptionalInt openGuiScreen(MenuProvider factory) {
        return this.getEntity().openMenu(factory);
    }

    public OptionalInt openGuiScreen(Level world, BlockState state, BlockPos pos) {
        return this.openGuiScreen(state.getMenuProvider(world, pos));
    }

    public boolean isServerPlayerEntity() {
        return this.getEntity() instanceof ServerPlayer;
    }

    public void openExtendedMenu(MenuProvider provider, Consumer<FriendlyByteBuf> bufWriter) {
        if (this.isServerPlayerEntity()) {
            ScreenHandlerUtil.openExtendedMenu((ServerPlayer)this.getPlayerEntity(), provider, bufWriter);
        }
    }

    public void openExtendedMenu(ExtendedMenuProvider provider) {
        if (this.isServerPlayerEntity()) {
            ScreenHandlerUtil.openExtendedMenu((ServerPlayer)this.getPlayerEntity(), provider);
        }
    }

    public void openExtendedMenu(ExtendedNamedScreenHandlerFactory provider) {
        this.openExtendedMenu((ExtendedMenuProvider)provider);
    }

    public void openMenu(MenuProvider provider) {
        if (this.isServerPlayerEntity()) {
            ScreenHandlerUtil.openMenu((ServerPlayer)this.getPlayerEntity(), provider);
        }
    }

    public void insertStack(net.minecraft.world.item.ItemStack stack) {
        this.getInv().add(stack);
    }

    public void insertStack(int slot, net.minecraft.world.item.ItemStack stack) {
        this.getInv().add(slot, stack);
    }

    public void offerOrDrop(net.minecraft.world.item.ItemStack itemStack) {
        this.getInv().placeItemBackInInventory(itemStack);
    }

    public void giveStack(net.minecraft.world.item.ItemStack stack) {
        this.getEntity().addItem(stack);
    }

    public String getName() {
        return this.getEntity().getName().getString();
    }

    public UUID getUUID() {
        return this.getEntity().getUUID();
    }

    public Abilities getAbilities() {
        return this.getEntity().getAbilities();
    }

    public boolean isCreative() {
        return this.getAbilities().instabuild;
    }

    public boolean isFlying() {
        return this.getAbilities().flying;
    }

    public boolean isInvulnerable() {
        return this.getAbilities().invulnerable;
    }

    public Level getWorld() {
        return this.getEntity().level();
    }

    public AbstractContainerMenu getCurrentScreenHandler() {
        return this.getEntity().containerMenu;
    }

    public boolean isSneaking() {
        return this.getEntity().isShiftKeyDown();
    }

    public net.minecraft.world.item.ItemStack getCursorStack() {
        return this.getCurrentScreenHandler().getCarried();
    }

    public boolean isClient() {
        return this.getWorld().isClientSide();
    }

    public boolean isServer() {
        return !this.isClient();
    }

    public void readCustomDataFromNbt(CompoundTag nbt) {
        this.getEntity().setComponent(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
    }

    public void writeCustomDataToNbt(CompoundTag nbt) {
        CompoundTag source = ((CustomData)this.getEntity().get(DataComponents.CUSTOM_DATA)).copyTag();
        NbtUtil.copyFrom(source, nbt);
    }

    public void sendMessage(Component text) {
        this.getEntity().displayClientMessage(text, false);
    }

    public void sendActionBar(Component text) {
        this.getEntity().displayClientMessage(text, true);
    }

    public void equipStack(EquipmentSlot slot, net.minecraft.world.item.ItemStack stack) {
        this.getEntity().setItemSlot(slot, stack);
    }

    public void dropStack(net.minecraft.world.item.ItemStack stack, boolean throwRandomly, boolean retainOwnership) {
        this.getEntity().drop(stack, throwRandomly, retainOwnership);
    }

    public void dropStack(net.minecraft.world.item.ItemStack stack, boolean retainOwnership) {
        this.dropStack(stack, false, retainOwnership);
    }

    public void dropStack(net.minecraft.world.item.ItemStack stack) {
        this.dropStack(stack, false, false);
    }

    public BlockPos getBlockPos() {
        return this.getEntity().blockPosition();
    }

    public Vec3 getPos() {
        return this.getEntity().position();
    }

    public net.minecraft.world.item.ItemStack getStackInHand(InteractionHand hand) {
        return this.getEntity().getItemInHand(hand);
    }

    public void heal(float amount) {
        this.getEntity().heal(amount);
    }

    public float getYaw() {
        return this.getEntity().getYRot();
    }

    public float getPitch() {
        return this.getEntity().getXRot();
    }

    public void playSound(SoundEvent event, SoundSource category, float volume, float pitch) {
        Optional<ServerPlayer> player;
        if (this.isServerPlayerEntity() && (player = this.getServerPlayer()).isPresent()) {
            player.get().playNotifySound(event, category, volume, pitch);
            return;
        }
        this.playSound(event, volume, pitch);
    }

    public void playSound(SoundEvent event, float volume, float pitch) {
        Optional<ServerPlayer> player;
        if (this.isServerPlayerEntity() && (player = this.getServerPlayer()).isPresent()) {
            player.get().playSound(event, volume, pitch);
            return;
        }
        this.getEntity().playSound(event, volume, pitch);
    }

    public void playSound(CompatSoundEvent event, CompatSoundCategory category, float volume, float pitch) {
        this.playSound(event.get(), category.get(), volume, pitch);
    }

    public void playSound(CompatSoundEvent event, float volume, float pitch) {
        this.playSound(event.get(), volume, pitch);
    }

    public ItemCooldown getItemCooldown() {
        return this.itemCooldown;
    }

    public ItemCooldowns getItemCooldownManager() {
        return this.getEntity().getCooldowns();
    }

    public void incrementStat(Stat<?> stat) {
        this.getEntity().awardStat(stat);
    }

    public <T> void incrementStat(StatType<T> type, T object) {
        this.getEntity().awardStat(type.get(object));
    }

    public void incrementStat(ResourceLocation id) {
        this.getEntity().awardStat(id);
    }

    public void incrementStat(CompatIdentifier id) {
        this.getEntity().awardStat(id.toMinecraft());
    }

    public void teleport(double x, double y, double z) {
        this.getEntity().randomTeleport(x, y, z, false);
    }

    public net.minecraft.world.item.ItemStack getMainHandStack() {
        return this.getStackInHand(InteractionHand.MAIN_HAND);
    }

    public net.minecraft.world.item.ItemStack getOffHandStack() {
        return this.getStackInHand(InteractionHand.OFF_HAND);
    }

    public Direction getHorizontalFacing() {
        return this.getEntity().getDirection();
    }

    public double getX() {
        return this.getEntity().getX();
    }

    public double getY() {
        return this.getEntity().getY();
    }

    public double getZ() {
        return this.getEntity().getZ();
    }

    public boolean isServerPlayer() {
        return this.getEntity() instanceof ServerPlayer;
    }

    public Optional<ServerPlayer> getServerPlayer() {
        if (this.isServerPlayer()) {
            return Optional.of((ServerPlayer)this.getEntity());
        }
        return Optional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<LocalPlayer> getClientPlayer() {
        if (this.getEntity() instanceof LocalPlayer) {
            return Optional.of((LocalPlayer)this.getEntity());
        }
        return Optional.empty();
    }

    public void setVelocity(double x, double y, double z) {
        this.getEntity().setDeltaMovement(x, y, z);
    }

    public void setVelocity(Vec3 velocity) {
        this.getEntity().setDeltaMovement(velocity);
    }

    public Vec3 getVelocity() {
        return this.getEntity().getDeltaMovement();
    }

    public Optional<ServerGamePacketListenerImpl> getNetworkHandler() {
        Optional<ServerPlayer> player = this.getServerPlayer();
        return player.map(sp -> sp.connection);
    }

    public boolean hasNetworkHandler() {
        return this.getNetworkHandler().isPresent();
    }

    public boolean isSpectator() {
        return this.getEntity().isSpectator();
    }

    public Optional<net.minecraft.world.item.ItemStack> getCurrentHandItem() {
        boolean playerIsHoldingInOffHand;
        boolean playerIsHoldingInMainHand;
        boolean bl = playerIsHoldingInMainHand = !this.getMainHandStack().isEmpty();
        if (playerIsHoldingInMainHand) {
            return Optional.ofNullable(this.getMainHandStack());
        }
        boolean bl2 = playerIsHoldingInOffHand = !this.getOffHandStack().isEmpty();
        if (playerIsHoldingInOffHand) {
            return Optional.ofNullable(this.getOffHandStack());
        }
        return Optional.empty();
    }

    public void addStatusEffect(CompatStatusEffectInstance effect) {
        this.getEntity().addEffect(effect.getInstance());
    }

    public void removeStatusEffect(CompatStatusEffect effect) {
        this.getEntity().removeEffect(effect.getEntry(this.getWorld()));
    }

    public List<CompatStatusEffectInstance> getStatusEffects() {
        ArrayList<CompatStatusEffectInstance> compatEffects = new ArrayList<CompatStatusEffectInstance>();
        for (MobEffectInstance effect : this.getEntity().getActiveEffects()) {
            compatEffects.add(new CompatStatusEffectInstance(effect));
        }
        return compatEffects;
    }

    public void addExperience(int experience) {
        this.getEntity().giveExperiencePoints(experience);
    }

    public int getExperienceLevel() {
        return this.getEntity().experienceLevel;
    }

    public void addExperienceLevels(int levels) {
        this.getEntity().giveExperienceLevels(levels);
    }

    public void setExperienceLevel(int level) {
        this.getEntity().experienceLevel = level;
    }

    public void addScore(int score) {
        this.getEntity().increaseScore(score);
    }

    public int getScore() {
        return this.getEntity().getScore();
    }

    public void setScore(int score) {
        this.getEntity().setScore(score);
    }

    public int getTotalExperience() {
        return this.getEntity().totalExperience;
    }

    public void setTotalExperience(int experience) {
        this.getEntity().totalExperience = experience;
    }

    public boolean isSwimming() {
        return this.getEntity().isSwimming();
    }

    public void setStackInHand(InteractionHand hand, net.minecraft.world.item.ItemStack stack) {
        this.getEntity().setItemInHand(hand, stack);
    }

    public void setStackInHand(InteractionHand hand, ItemStack stack) {
        this.setStackInHand(hand, stack.toMinecraft());
    }

    public ItemStack getMidohraStackInHand(InteractionHand hand) {
        return ItemStack.of(this.getStackInHand(hand));
    }

    public InteractionHand getActiveHand() {
        return this.getEntity().getUsedItemHand();
    }

    public float getBlockBreakingSpeed(BlockState state) {
        return this.getEntity().getDestroySpeed(state);
    }

    public boolean canHarvest(BlockState state) {
        return this.getEntity().hasCorrectToolForDrops(state);
    }

    public World getMidohraWorld() {
        return World.of(this.getWorld());
    }

    public void eatFood(net.minecraft.world.item.ItemStack stack, CompatFoodComponent foodComponent) {
        this.getEntity().getFoodData().eat(foodComponent.build());
    }
}

