/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.item.equipment;

import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.equipment.Equippable;
import net.pitan76.mcpitanlib.api.item.ArmorEquipmentType;
import net.pitan76.mcpitanlib.api.item.equipment.CompatEquipmentAsset;
import net.pitan76.mcpitanlib.api.item.equipment.CompatEquippableComponent;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvent;
import net.pitan76.mcpitanlib.api.tag.TagKey;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;

public class EquippableComponentBuilder {
    public ArmorEquipmentType equipmentType;
    public CompatSoundEvent equipSound;
    public CompatSoundEvent shearingSound;
    public boolean equipOnInteract = false;
    public boolean canBeSheared = false;
    public CompatEquipmentAsset model;
    public TagKey<?> allowedEntities = null;

    public EquippableComponentBuilder() {
    }

    public EquippableComponentBuilder(ArmorEquipmentType equipmentType) {
        this.equipmentType = equipmentType;
    }

    public EquippableComponentBuilder equipmentType(ArmorEquipmentType equipmentType) {
        this.equipmentType = equipmentType;
        return this;
    }

    public EquippableComponentBuilder equipSound(CompatSoundEvent equipSound) {
        this.equipSound = equipSound;
        return this;
    }

    public EquippableComponentBuilder shearingSound(CompatSoundEvent shearingSound) {
        this.shearingSound = shearingSound;
        return this;
    }

    public EquippableComponentBuilder equipOnInteract(boolean equipOnInteract) {
        this.equipOnInteract = equipOnInteract;
        return this;
    }

    public EquippableComponentBuilder canBeSheared(boolean canBeSheared) {
        this.canBeSheared = canBeSheared;
        return this;
    }

    public EquippableComponentBuilder model(CompatEquipmentAsset model) {
        this.model = model;
        return this;
    }

    public EquippableComponentBuilder model(CompatIdentifier id) {
        return this.model(CompatEquipmentAsset.of(id));
    }

    public EquippableComponentBuilder allowedEntities(TagKey<?> allowedEntities) {
        this.allowedEntities = allowedEntities;
        return this;
    }

    public EquippableComponentBuilder allowedEntities(CompatIdentifier tagId) {
        return this.allowedEntities(TagKey.create(TagKey.Type.ENTITY_TYPE, tagId));
    }

    public EquippableComponentBuilder allowedEntities(String tagId) {
        return this.allowedEntities(CompatIdentifier.of(tagId));
    }

    public CompatEquippableComponent build() {
        Equippable.Builder component = Equippable.builder((EquipmentSlot)this.equipmentType.getSlot());
        if (this.equipSound != null) {
            component.setEquipSound(this.equipSound.getEntry() != null ? this.equipSound.getEntry() : this.equipSound.getReference());
        }
        if (this.shearingSound != null) {
            component.setShearingSound(this.shearingSound.getEntry() != null ? this.shearingSound.getEntry() : this.shearingSound.getReference());
        }
        component.setEquipOnInteract(this.equipOnInteract);
        component.setCanBeSheared(this.canBeSheared);
        if (this.model != null) {
            component.setAsset(this.model.raw());
        }
        if (this.allowedEntities != null) {
            HolderGetter registryEntryLookup = BuiltInRegistries.acquireBootstrapRegistrationLookup((Registry)BuiltInRegistries.ENTITY_TYPE);
            component.setAllowedEntities((HolderSet)registryEntryLookup.getOrThrow(this.allowedEntities.getTagKey()));
        }
        return CompatEquippableComponent.of(component.build());
    }
}

