/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.pitan76.mcpitanlib.api.item.v2.CompatibleItemSettings;
import net.pitan76.mcpitanlib.api.tag.TagKey;
import net.pitan76.mcpitanlib.api.text.TextComponent;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;

public class ItemUtil {
    public static boolean isEqual(Item item, Item item2) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.isEqual(item, item2);
    }

    public static Item fromId(CompatIdentifier id) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.fromId(id);
    }

    public static Item fromId(String id) {
        return ItemUtil.fromId(CompatIdentifier.of(id));
    }

    public static Item fromId(String namespace, String path) {
        return ItemUtil.fromId(CompatIdentifier.of(namespace, path));
    }

    public static CompatIdentifier toId(Item item) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.toCompatID(item);
    }

    public static String toIdAsString(Item item) {
        return ItemUtil.toId(item).toString();
    }

    public static boolean isExist(CompatIdentifier id) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.isExist(id);
    }

    public static boolean isExist(String id) {
        return ItemUtil.isExist(CompatIdentifier.of(id));
    }

    public static boolean isExist(String namespace, String path) {
        return ItemUtil.isExist(CompatIdentifier.of(namespace, path));
    }

    public static boolean isMinecraftItem(Item item) {
        return CompatIdentifier.isMinecraftNamespace(ItemUtil.toId(item));
    }

    public static BlockItem create(Block block, CompatibleItemSettings settings) {
        if (!settings.changedTranslationKey) {
            settings.useBlockPrefixedTranslationKey();
        }
        return net.pitan76.mcpitanlib.api.util.ItemUtil.ofBlock(block, settings);
    }

    public static Item create(CompatibleItemSettings settings) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.of(settings);
    }

    public static List<Item> getItems() {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.getAllItems();
    }

    public static List<Item> getInTag(TagKey<Item> tagKey) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.getItems(tagKey);
    }

    public static List<Item> getInTag(CompatIdentifier id) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.getItems(id);
    }

    public static List<Item> getInTag(String id) {
        return ItemUtil.getInTag(CompatIdentifier.of(id));
    }

    public static List<Item> getInTag(String namespace, String path) {
        return ItemUtil.getInTag(CompatIdentifier.of(namespace, path));
    }

    public static boolean isInTag(Item item, TagKey<Item> tagKey) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.isIn(item, tagKey);
    }

    public static boolean isInTag(Item item, CompatIdentifier id) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.isItemInTag(item, id);
    }

    public static boolean isInTag(Item item, String id) {
        return ItemUtil.isInTag(item, CompatIdentifier.of(id));
    }

    public static boolean isInTag(Item item, String namespace, String path) {
        return ItemUtil.isInTag(item, CompatIdentifier.of(namespace, path));
    }

    public static int toRawId(Item item) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.getRawId(item);
    }

    public static Item fromRawId(int rawId) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.fromIndex(rawId);
    }

    public static List<Item> getItemsByNamespace(String namespace) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (Item item : ItemUtil.getItems()) {
            if (!ItemUtil.toId(item).getNamespace().equals(namespace)) continue;
            items.add(item);
        }
        return items;
    }

    public static int getNumberOfItems() {
        return ItemUtil.getItems().size();
    }

    public static Item of(ItemStack stack) {
        return stack.getItem();
    }

    public static boolean isOf(ItemStack stack, Item item) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.isOf(stack, item);
    }

    public static String getNameAsString(Item item) {
        return item.getName().getString();
    }

    public static TextComponent getName(Item item) {
        return new TextComponent(item.getName());
    }

    public static String getTranslationKey(Item item) {
        return item.getDescriptionId();
    }

    public static boolean hasRecipeRemainder(Item item) {
        return !ItemStackUtil.isEmpty(ItemUtil.getRecipeRemainderStack(item));
    }

    public static Item getRecipeRemainder(Item item) {
        return ItemUtil.getRecipeRemainderStack(item).getItem();
    }

    public static ItemStack getRecipeRemainderStack(Item item) {
        return item.getCraftingRemainder();
    }
}

