/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.nbt.v2;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.pitan76.mcpitanlib.api.event.nbt.ReadNbtArgs;
import net.pitan76.mcpitanlib.api.event.nbt.WriteNbtArgs;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.util.collection.ItemStackList;
import net.pitan76.mcpitanlib.api.util.math.PosUtil;
import net.pitan76.mcpitanlib.api.util.math.Vec3dUtil;
import net.pitan76.mcpitanlib.api.util.math.Vec3iUtil;
import net.pitan76.mcpitanlib.api.util.nbt.InvRWUtil;

public class NbtRWUtil
extends net.pitan76.mcpitanlib.api.util.nbt.NbtRWUtil {
    public static void putInv(WriteNbtArgs args, ItemStackList stacks) {
        InvRWUtil.putInv(args, stacks);
    }

    public static void getInv(ReadNbtArgs args, ItemStackList stacks) {
        InvRWUtil.getInv(args, stacks);
    }

    public static WriteNbtArgs create(CompatRegistryLookup registryLookup) {
        TagValueOutput view = NbtRWUtil._view(registryLookup);
        return new WriteNbtArgs(view.buildResult(), (ValueOutput)view, registryLookup);
    }

    public static WriteNbtArgs create() {
        return NbtRWUtil.create(null);
    }

    public static void put(WriteNbtArgs parent, WriteNbtArgs child, String key) {
        ValueOutput valueOutput = child.view;
        if (valueOutput instanceof TagValueOutput) {
            TagValueOutput childView = (TagValueOutput)valueOutput;
            parent.view.store(key, CompoundTag.CODEC, (Object)childView.buildResult());
        }
    }

    public static WriteNbtArgs putWithCreate(WriteNbtArgs parent, String key) {
        TagValueOutput subView = NbtRWUtil._view(parent.registryLookup);
        parent.view.store(key, CompoundTag.CODEC, (Object)subView.buildResult());
        return new WriteNbtArgs(subView.buildResult(), (ValueOutput)subView, parent.registryLookup);
    }

    public static ReadNbtArgs get(ReadNbtArgs parent, String key) {
        ValueInput view = parent.view.childOrEmpty(key);
        return new ReadNbtArgs(null, view, parent.registryLookup);
    }

    public static ReadNbtArgs getOrDefault(ReadNbtArgs parent, String key, ReadNbtArgs defaultValue) {
        Optional view = parent.view.child(key);
        return view.map(readView -> new ReadNbtArgs(null, (ValueInput)readView, parent.registryLookup)).orElse(defaultValue);
    }

    public static void putPos3i(WriteNbtArgs args, String key, int x, int y, int z) {
        WriteNbtArgs args2 = NbtRWUtil.putWithCreate(args, key);
        NbtRWUtil.putInt(args2, "x", x);
        NbtRWUtil.putInt(args2, "y", y);
        NbtRWUtil.putInt(args2, "z", z);
    }

    public static void putPos3d(WriteNbtArgs args, String key, double x, double y, double z) {
        WriteNbtArgs args2 = NbtRWUtil.putWithCreate(args, key);
        NbtRWUtil.putDouble(args2, "x", x);
        NbtRWUtil.putDouble(args2, "y", y);
        NbtRWUtil.putDouble(args2, "z", z);
    }

    public static Vec3i getPos3i(ReadNbtArgs args, String key) {
        ReadNbtArgs args2 = NbtRWUtil.get(args, key);
        int x = NbtRWUtil.getInt(args2, "x");
        int y = NbtRWUtil.getInt(args2, "y");
        int z = NbtRWUtil.getInt(args2, "z");
        return Vec3iUtil.create(x, y, z);
    }

    public static Vec3 getPos3d(ReadNbtArgs args, String key) {
        ReadNbtArgs args2 = NbtRWUtil.get(args, key);
        double x = NbtRWUtil.getDouble(args2, "x");
        double y = NbtRWUtil.getDouble(args2, "y");
        double z = NbtRWUtil.getDouble(args2, "z");
        return Vec3dUtil.create(x, y, z);
    }

    public static void putBlockPos(WriteNbtArgs args, String key, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos) {
        NbtRWUtil.putPos3i(args, key, pos.getX(), pos.getY(), pos.getZ());
    }

    public static net.pitan76.mcpitanlib.midohra.util.math.BlockPos getBlockPos(ReadNbtArgs args, String key) {
        ReadNbtArgs args2 = NbtRWUtil.get(args, key);
        int x = NbtRWUtil.getInt(args2, "x");
        int y = NbtRWUtil.getInt(args2, "y");
        int z = NbtRWUtil.getInt(args2, "z");
        return net.pitan76.mcpitanlib.midohra.util.math.BlockPos.of(x, y, z);
    }

    public static void putBlockPos(WriteNbtArgs args, String key, BlockPos pos) {
        NbtRWUtil.putPos3i(args, key, PosUtil.x(pos), PosUtil.y(pos), PosUtil.z(pos));
    }

    public static BlockPos getBlockPosV(ReadNbtArgs args, String key) {
        ReadNbtArgs args2 = NbtRWUtil.get(args, key);
        int x = NbtRWUtil.getInt(args2, "x");
        int y = NbtRWUtil.getInt(args2, "y");
        int z = NbtRWUtil.getInt(args2, "z");
        return PosUtil.flooredBlockPos(x, y, z);
    }

    private static TagValueOutput _view(CompatRegistryLookup registryLookup) {
        return TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)registryLookup.getRegistryLookup());
    }

    public static void putItemStack(WriteNbtArgs args, String key, ItemStack stack) {
        args.view.store(key, ItemStack.CODEC, (Object)stack);
    }

    public static Optional<ItemStack> getItemStack(ReadNbtArgs args, String key) {
        return args.view.read(key, ItemStack.CODEC);
    }
}

