/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.client.render.block.entity.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.pitan76.mcpitanlib.api.tile.CompatBlockEntity;
import net.pitan76.mcpitanlib.api.util.MathUtil;
import net.pitan76.mcpitanlib.api.util.client.ClientUtil;
import net.pitan76.mcpitanlib.api.util.client.MatrixStackUtil;

public class BlockEntityRenderEvent<T extends CompatBlockEntity> {
    public T blockEntity;
    public float tickDelta;
    public PoseStack matrices;
    public MultiBufferSource vertexConsumers;
    int light;
    int overlay;

    public BlockEntityRenderEvent(T blockEntity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        this.blockEntity = blockEntity;
        this.tickDelta = tickDelta;
        this.matrices = matrices;
        this.vertexConsumers = vertexConsumers;
        this.light = light;
        this.overlay = overlay;
    }

    public T getBlockEntity() {
        return this.blockEntity;
    }

    public PoseStack getMatrices() {
        return this.matrices;
    }

    public float getTickDelta() {
        return this.tickDelta;
    }

    public int getLight() {
        return this.light;
    }

    public int getOverlay() {
        return this.overlay;
    }

    public VertexConsumer getVertexConsumer(RenderType layer) {
        return this.vertexConsumers.getBuffer(layer);
    }

    public MultiBufferSource getVertexConsumers() {
        return this.vertexConsumers;
    }

    public void push() {
        MatrixStackUtil.push(this.matrices);
    }

    public void translate(double x, double y, double z) {
        MatrixStackUtil.translate(this.matrices, x, y, z);
    }

    public void pop() {
        MatrixStackUtil.pop(this.matrices);
    }

    public void multiply(MathUtil.RotationAxisType type, float deg) {
        MatrixStackUtil.multiply(this.matrices, type, deg);
    }

    public void scale(float x, float y, float z) {
        MatrixStackUtil.scale(this.matrices, x, y, z);
    }

    public ItemRenderer getItemRenderer() {
        return ClientUtil.getItemRenderer();
    }

    public boolean isRemoved() {
        return this.blockEntity.isRemoved();
    }
}

