/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.v0;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.events.common.InteractionEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.pitan76.mcpitanlib.api.event.result.EventResult;
import net.pitan76.mcpitanlib.api.event.v0.event.ClickBlockEvent;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import net.pitan76.mcpitanlib.api.util.StackActionResult;

public class InteractionEventRegistry {
    public static void registerRightClickBlock(RightClickBlock rightClickBlock) {
        InteractionEvent.RIGHT_CLICK_BLOCK.register((player, hand, pos, direction) -> rightClickBlock.click(new ClickBlockEvent(player, hand, pos, direction)).getResult());
    }

    public static void registerLeftClickBlock(LeftClickBlock leftClickBlock) {
        InteractionEvent.LEFT_CLICK_BLOCK.register((player, hand, pos, direction) -> leftClickBlock.click(new ClickBlockEvent(player, hand, pos, direction)).getResult());
    }

    public static void registerRightClickItem(RightClickItem rightClickItem) {
        InteractionEvent.RIGHT_CLICK_ITEM.register(rightClickItem::click);
    }

    public static void registerClientLeftClickAir(ClientLeftClickAir clientLeftClickAir) {
        InteractionEvent.CLIENT_LEFT_CLICK_AIR.register(clientLeftClickAir::click);
    }

    public static void registerClientRightClickAir(ClientRightClickAir clientRightClickAir) {
        InteractionEvent.CLIENT_RIGHT_CLICK_AIR.register(clientRightClickAir::click);
    }

    public static void registerInteractEntity(InteractEntity interactEntity) {
        InteractionEvent.INTERACT_ENTITY.register(interactEntity::interact);
    }

    public static interface RightClickBlock {
        public EventResult click(ClickBlockEvent var1);
    }

    public static interface LeftClickBlock {
        public EventResult click(ClickBlockEvent var1);
    }

    public static interface RightClickItem {
        default public CompoundEventResult<ItemStack> click(Player var1, InteractionHand var2) {
            ItemStack stack;
            CompatActionResult result = this.click(new net.pitan76.mcpitanlib.api.entity.Player(var1), var2);
            ItemStack itemStack = stack = result instanceof StackActionResult ? ((StackActionResult)result).getStack() : var1.getItemInHand(var2);
            if (result.equals(CompatActionResult.SUCCESS) || result.equals(CompatActionResult.CONSUME) || result.equals(CompatActionResult.SUCCESS_SERVER)) {
                return CompoundEventResult.interruptTrue((Object)stack);
            }
            if (result.equals(CompatActionResult.FAIL)) {
                return CompoundEventResult.interruptFalse((Object)stack);
            }
            if (result.equals(CompatActionResult.STOP)) {
                return CompoundEventResult.interrupt(null, (Object)stack);
            }
            return CompoundEventResult.pass();
        }

        public CompatActionResult click(net.pitan76.mcpitanlib.api.entity.Player var1, InteractionHand var2);
    }

    public static interface ClientLeftClickAir {
        default public void click(Player var1, InteractionHand var2) {
            this.click(new net.pitan76.mcpitanlib.api.entity.Player(var1), var2);
        }

        public void click(net.pitan76.mcpitanlib.api.entity.Player var1, InteractionHand var2);
    }

    public static interface ClientRightClickAir {
        default public void click(Player var1, InteractionHand var2) {
            this.click(new net.pitan76.mcpitanlib.api.entity.Player(var1), var2);
        }

        public void click(net.pitan76.mcpitanlib.api.entity.Player var1, InteractionHand var2);
    }

    public static interface InteractEntity {
        default public dev.architectury.event.EventResult interact(Player var1, Entity var2, InteractionHand var3) {
            return this.interact(new net.pitan76.mcpitanlib.api.entity.Player(var1), var2, var3).toEventResult().getResult();
        }

        public CompatActionResult interact(net.pitan76.mcpitanlib.api.entity.Player var1, Entity var2, InteractionHand var3);
    }
}

