/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.nbt.NbtRWArgs;
import net.pitan76.mcpitanlib.midohra.item.ItemWrapper;

public class ItemStackUtil {
    public static ItemStack copy(ItemStack stack) {
        return stack.copy();
    }

    public static ItemStack copyWithCount(ItemStack stack, int count) {
        return stack.copyWithCount(count);
    }

    public static boolean areItemsEqual(ItemStack left, ItemStack right) {
        return ItemStack.isSameItem((ItemStack)left, (ItemStack)right);
    }

    @Deprecated
    public static boolean areNbtEqual(ItemStack left, ItemStack right) {
        return ItemStackUtil.areNbtOrComponentEqual(left, right);
    }

    public static boolean areNbtOrComponentEqual(ItemStack left, ItemStack right) {
        return Objects.equals(left.getTag(), right.getTag());
    }

    public static boolean hasNbtOrComponent(ItemStack stack) {
        return stack.hasTag();
    }

    public static ItemStack fromNbt(Level world, CompoundTag nbt) {
        return ItemStack.of((CompoundTag)nbt);
    }

    public static ItemStack fromNbt(NbtRWArgs args) {
        return ItemStack.of((CompoundTag)args.getNbt());
    }

    public static ItemStack getDefaultStack(Item item) {
        return item.getDefaultInstance();
    }

    public static int getMaxDamage(ItemStack stack) {
        return stack.getMaxDamage();
    }

    public static int getMaxDamage(Item item) {
        return ItemStackUtil.getMaxDamage(ItemStackUtil.getDefaultStack(item));
    }

    public static int getDamage(ItemStack stack) {
        return stack.getDamageValue();
    }

    public static void setDamage(ItemStack stack, int damage) {
        stack.setDamageValue(damage);
    }

    public static int getCount(ItemStack stack) {
        return stack.getCount();
    }

    public static void setCount(ItemStack stack, int count) {
        stack.setCount(count);
    }

    public static void decrementCount(ItemStack stack, int count) {
        stack.shrink(count);
    }

    public static void incrementCount(ItemStack stack, int count) {
        stack.grow(count);
    }

    public static void damage(ItemStack stack, int amount, ServerPlayer entity, Runnable breakCallback) {
        stack.hurtAndBreak(amount, (LivingEntity)entity, player -> breakCallback.run());
    }

    public static void damage(ItemStack stack, int amount, LivingEntity entity, EquipmentSlot slot) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer entity1 = (ServerPlayer)entity;
            ItemStackUtil.damage(stack, amount, entity1, () -> {});
        }
    }

    public static void damage(ItemStack stack, int amount, ServerPlayer entity) {
        stack.hurtAndBreak(amount, (LivingEntity)entity, entity2 -> entity2.broadcastBreakEvent(EquipmentSlot.MAINHAND));
    }

    public static void damage(ItemStack stack, int amount, Player entity) {
        Optional<ServerPlayer> player = entity.getServerPlayer();
        if (player.isEmpty()) {
            return;
        }
        ItemStackUtil.damage(stack, amount, player.get());
    }

    public static ItemStack empty() {
        return ItemStack.EMPTY;
    }

    public static ItemStack create(Item item) {
        return new ItemStack((ItemLike)item);
    }

    public static ItemStack create(Item item, int count) {
        return new ItemStack((ItemLike)item, count);
    }

    public static ItemStack create(ItemLike item) {
        return new ItemStack(item);
    }

    public static ItemStack create(ItemLike item, int count) {
        return new ItemStack(item, count);
    }

    public static boolean isEmpty(ItemStack stack) {
        return stack.isEmpty();
    }

    public static boolean isEnchantable(ItemStack stack) {
        return stack.isEnchantable();
    }

    public static boolean isDamageable(ItemStack stack) {
        return stack.isDamageableItem();
    }

    public static boolean isBreak(ItemStack stack) {
        if (ItemStackUtil.isDamageable(stack)) {
            return ItemStackUtil.getDamage(stack) >= ItemStackUtil.getMaxDamage(stack);
        }
        return false;
    }

    public static ItemWrapper getItemWrapper(ItemStack stack) {
        return ItemWrapper.of(stack.getItem());
    }

    public static int getMaxCount(ItemStack stack) {
        return stack.getMaxStackSize();
    }

    public static Item getItem(ItemStack stack) {
        return stack.getItem();
    }
}

