/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeUtil {
    public static VoxelShape union(VoxelShape shape, VoxelShape ... shapes) {
        return Shapes.or((VoxelShape)shape, (VoxelShape[])shapes);
    }

    public static VoxelShape cuboid(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Shapes.box((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public static VoxelShape cuboid(double x, double y, double z, double size) {
        return Shapes.box((double)x, (double)y, (double)z, (double)(x + size), (double)(y + size), (double)(z + size));
    }

    public static VoxelShape cuboid(double size) {
        return Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)size, (double)size, (double)size);
    }

    public static VoxelShape centeredCuboid(double x, double y, double z, double size) {
        return Shapes.box((double)(x - size / 2.0), (double)(y - size / 2.0), (double)(z - size / 2.0), (double)(x + size / 2.0), (double)(y + size / 2.0), (double)(z + size / 2.0));
    }

    public static VoxelShape empty() {
        return Shapes.empty();
    }

    public static VoxelShape fullCube() {
        return Shapes.block();
    }

    public static VoxelShape blockCuboid(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return Shapes.box((double)(minX / 16.0), (double)(minY / 16.0), (double)(minZ / 16.0), (double)(maxX / 16.0), (double)(maxY / 16.0), (double)(maxZ / 16.0));
    }

    public static AABB getBoundingBox(VoxelShape shape) {
        return shape.bounds();
    }
}

