/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.recipe.input;

import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.ticks.ContainerSingleItem;
import net.pitan76.mcpitanlib.api.recipe.input.CompatRecipeInput;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;

public class SingleStackRecipeInputUtil {
    public static Optional<ContainerSingleItem> get(CompatRecipeInput<?> input) {
        if (input.getInput() instanceof ContainerSingleItem) {
            return Optional.of((ContainerSingleItem)input.getInput());
        }
        return Optional.empty();
    }

    public static CompatRecipeInput<?> create(ContainerSingleItem input) {
        return new CompatRecipeInput<ContainerSingleItem>(input);
    }

    public static CompatRecipeInput<?> create(final ItemStack stack) {
        return new CompatRecipeInput<1>(new ContainerSingleItem(){
            private ItemStack itemStack;
            {
                this.itemStack = stack;
            }

            public void setChanged() {
            }

            public ItemStack getTheItem() {
                return this.itemStack;
            }

            public ItemStack splitTheItem(int count) {
                ItemStackUtil.decrementCount(this.itemStack, count);
                return this.itemStack;
            }

            public void setTheItem(ItemStack stack2) {
                this.itemStack = stack2;
            }

            public BlockEntity getContainerBlockEntity() {
                return null;
            }
        });
    }

    public static ItemStack getStack(CompatRecipeInput<?> input) {
        Optional<ContainerSingleItem> recipeInput = SingleStackRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return ItemStackUtil.empty();
        }
        return recipeInput.get().getItem(0);
    }
}

