/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.math.random;

import java.util.Random;
import net.minecraft.util.RandomSource;

public class CompatRandom {
    private Random javaRandom;
    private RandomSource mcRandom;

    public CompatRandom(Random javaRandom) {
        this.javaRandom = javaRandom;
    }

    public CompatRandom(RandomSource mcRandom) {
        this.mcRandom = mcRandom;
    }

    @Deprecated
    public CompatRandom() {
        this.mcRandom = RandomSource.m_216327_();
    }

    @Deprecated
    public CompatRandom(long seed) {
        this.mcRandom = RandomSource.m_216335_((long)seed);
    }

    public static CompatRandom of(long seed) {
        return new CompatRandom(seed);
    }

    public static CompatRandom of() {
        return new CompatRandom();
    }

    public void setSeed(long seed) {
        if (this.javaRandom != null) {
            this.javaRandom.setSeed(seed);
        } else {
            this.mcRandom.m_188584_(seed);
        }
    }

    public void skip(int count) {
        if (this.javaRandom != null) {
            for (int i = 0; i < count; ++i) {
                this.javaRandom.nextInt();
            }
        } else {
            this.mcRandom.m_190110_(count);
        }
    }

    public void split() {
        if (this.javaRandom != null) {
            this.javaRandom.nextInt();
        } else {
            this.mcRandom.m_213769_();
        }
    }

    public int nextInt() {
        if (this.javaRandom != null) {
            return this.javaRandom.nextInt();
        }
        return this.mcRandom.m_188502_();
    }

    public int nextInt(int bound) {
        if (this.javaRandom != null) {
            return this.javaRandom.nextInt(bound);
        }
        return this.mcRandom.m_188503_(bound);
    }

    public long nextLong() {
        if (this.javaRandom != null) {
            return this.javaRandom.nextLong();
        }
        return this.mcRandom.m_188505_();
    }

    public double nextDouble() {
        if (this.javaRandom != null) {
            return this.javaRandom.nextDouble();
        }
        return this.mcRandom.m_188500_();
    }

    public double nextGaussian() {
        if (this.javaRandom != null) {
            return this.javaRandom.nextGaussian();
        }
        return this.mcRandom.m_188583_();
    }

    public float nextFloat() {
        if (this.javaRandom != null) {
            return this.javaRandom.nextFloat();
        }
        return this.mcRandom.m_188501_();
    }

    public int nextBetween(int min, int max) {
        if (this.javaRandom != null) {
            return min + this.javaRandom.nextInt(max - min);
        }
        return min + this.mcRandom.m_188503_(max - min);
    }

    public int nextBetweenExclusive(int min, int max) {
        if (this.javaRandom != null) {
            return min + this.javaRandom.nextInt(max - min - 1);
        }
        return min + this.mcRandom.m_188503_(max - min - 1);
    }

    public boolean nextBoolean() {
        if (this.javaRandom != null) {
            return this.javaRandom.nextBoolean();
        }
        return this.mcRandom.m_188499_();
    }

    @Deprecated
    public Random getJavaRandom() {
        return this.javaRandom;
    }

    @Deprecated
    public RandomSource getMcRandom() {
        return this.mcRandom;
    }
}

