/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.util.math;

import java.util.stream.Stream;
import net.pitan76.mcpitanlib.midohra.util.math.BlockPos;

public class ChunkPos {
    private final net.minecraft.world.level.ChunkPos pos;

    protected ChunkPos(net.minecraft.world.level.ChunkPos pos) {
        this.pos = pos;
    }

    public static ChunkPos of(net.minecraft.world.level.ChunkPos pos) {
        return new ChunkPos(pos);
    }

    public static ChunkPos of(int x, int z) {
        return ChunkPos.of(new net.minecraft.world.level.ChunkPos(x, z));
    }

    public static ChunkPos of(BlockPos pos) {
        return ChunkPos.of(new net.minecraft.world.level.ChunkPos(pos.toMinecraft()));
    }

    public static ChunkPos of(long pos) {
        return ChunkPos.of(new net.minecraft.world.level.ChunkPos(pos));
    }

    public static ChunkPos fromRegion(int x, int z) {
        return ChunkPos.of(net.minecraft.world.level.ChunkPos.m_220337_((int)x, (int)z));
    }

    public static ChunkPos fromRegionCenter(int x, int z) {
        return ChunkPos.of(net.minecraft.world.level.ChunkPos.m_220340_((int)x, (int)z));
    }

    public net.minecraft.world.level.ChunkPos getRaw() {
        return this.pos;
    }

    public net.minecraft.world.level.ChunkPos toMinecraft() {
        return this.getRaw();
    }

    public int getX() {
        return this.getRaw().f_45578_;
    }

    public int getZ() {
        return this.getRaw().f_45579_;
    }

    public int getOffsetX(int offsetX) {
        return this.getRaw().m_151382_(offsetX);
    }

    public int getOffsetZ(int offsetZ) {
        return this.getRaw().m_151391_(offsetZ);
    }

    public int getStartX() {
        return this.getRaw().m_45604_();
    }

    public int getStartZ() {
        return this.getRaw().m_45605_();
    }

    public int getEndX() {
        return this.getRaw().m_45608_();
    }

    public int getEndZ() {
        return this.getRaw().m_45609_();
    }

    public int getCenterX() {
        return this.getRaw().m_151390_();
    }

    public int getCenterZ() {
        return this.getRaw().m_151393_();
    }

    public int getRegionX() {
        return this.getRaw().m_45610_();
    }

    public int getRegionZ() {
        return this.getRaw().m_45612_();
    }

    public int getRegionRelativeX() {
        return this.getRaw().m_45613_();
    }

    public int getRegionRelativeZ() {
        return this.getRaw().m_45614_();
    }

    public BlockPos getStartPos() {
        return BlockPos.of(this.getRaw().m_45615_());
    }

    public BlockPos getCenterAtY(int y) {
        return BlockPos.of(this.getRaw().m_151394_(y));
    }

    public BlockPos getBlockPos(int offsetX, int y, int offsetZ) {
        return BlockPos.of(this.getRaw().m_151384_(offsetX, y, offsetZ));
    }

    public long toLong() {
        return this.getRaw().m_45588_();
    }

    public String toString() {
        return this.getRaw().toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof ChunkPos && this.getRaw().equals((Object)((ChunkPos)obj).getRaw());
    }

    public int hashCode() {
        return this.getRaw().hashCode();
    }

    public int getChebyshevDistance(ChunkPos pos) {
        return this.getRaw().m_45594_(pos.getRaw());
    }

    public int getChebyshevDistance(int x, int z) {
        return this.getChebyshevDistance(ChunkPos.of(x, z));
    }

    public int getSquaredDistance(ChunkPos pos) {
        int dx = this.getX() - pos.getX();
        int dz = this.getZ() - pos.getZ();
        return dx * dx + dz * dz;
    }

    public int getSquaredDistance(long pos) {
        return this.getSquaredDistance(ChunkPos.of(pos));
    }

    public static Stream<ChunkPos> stream(ChunkPos center, int radius) {
        return net.minecraft.world.level.ChunkPos.m_45596_((net.minecraft.world.level.ChunkPos)center.getRaw(), (int)radius).map(ChunkPos::of);
    }

    public static Stream<ChunkPos> stream(ChunkPos pos1, ChunkPos pos2) {
        return net.minecraft.world.level.ChunkPos.m_45599_((net.minecraft.world.level.ChunkPos)pos1.getRaw(), (net.minecraft.world.level.ChunkPos)pos2.getRaw()).map(ChunkPos::of);
    }
}

