/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.client.gui.widget;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.pitan76.mcpitanlib.api.client.gui.widget.SimpleListWidget;
import net.pitan76.mcpitanlib.api.client.render.handledscreen.RenderArgs;
import net.pitan76.mcpitanlib.api.util.TextUtil;

@OnlyIn(value=Dist.CLIENT)
public class SimpleSliderWidget
extends AbstractSliderButton {
    protected final Function<Double, Component> textGetter = value -> valueTextGetter.get(text, (Double)value);
    protected final Consumer<Double> changeCallback;
    public SimpleListWidget listWidget = null;

    public SimpleSliderWidget(int x, int y, int width, int height, Component text, double defaultValue, ValueTextGetter<Double> valueTextGetter, Consumer<Double> changeCallback) {
        super(x, y, width, height, text, defaultValue);
        this.changeCallback = changeCallback;
        this.updateMessage();
    }

    public SimpleSliderWidget(int x, int y, int width, int height, double defaultValue, ValueTextGetter<Double> valueTextGetter, Consumer<Double> changeCallback) {
        this(x, y, width, height, (Component)TextUtil.empty(), defaultValue, valueTextGetter, changeCallback);
    }

    public SimpleSliderWidget(int x, int y, int width, Component text, double defaultValue, ValueTextGetter<Double> valueTextGetter, Consumer<Double> changeCallback) {
        this(x, y, width, 20, text, defaultValue, valueTextGetter, changeCallback);
    }

    public SimpleSliderWidget(int x, int y, int width, double defaultValue, ValueTextGetter<Double> valueTextGetter, Consumer<Double> changeCallback) {
        this(x, y, width, 20, defaultValue, valueTextGetter, changeCallback);
    }

    public SimpleSliderWidget(SimpleListWidget listWidget, int width, Component text, double defaultValue, ValueTextGetter<Double> valueTextGetter, Consumer<Double> changeCallback) {
        this(listWidget.getWidth() / 2 - 155, 0, width, 20, text, defaultValue, valueTextGetter, changeCallback);
        this.listWidget = listWidget;
    }

    public SimpleSliderWidget(SimpleListWidget listWidget, int width, double defaultValue, ValueTextGetter<Double> valueTextGetter, Consumer<Double> changeCallback) {
        this(listWidget, width, (Component)TextUtil.empty(), defaultValue, valueTextGetter, changeCallback);
    }

    public void render(RenderArgs args) {
        super.render(args.drawObjectDM.getContext(), args.mouseX, args.mouseY, args.delta);
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    protected void updateMessage() {
        this.setMessage(this.textGetter.apply(this.getValue()));
    }

    protected void applyValue() {
        this.changeCallback.accept(this.getValue());
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface ValueTextGetter<Double> {
        public Component get(Component var1, Double var2);
    }
}

