/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.pitan76.mcpitanlib.api.event.BaseEvent;
import net.pitan76.mcpitanlib.api.event.block.ItemScattererUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.midohra.block.BlockWrapper;
import net.pitan76.mcpitanlib.midohra.block.entity.BlockEntityWrapper;
import net.pitan76.mcpitanlib.midohra.world.IWorldView;
import net.pitan76.mcpitanlib.midohra.world.World;

public class StateReplacedEvent
extends BaseEvent {
    public BlockState state;
    public Level world;
    public BlockPos pos;
    public BlockState newState;
    public boolean moved;

    public StateReplacedEvent(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        this.state = state;
        this.world = world;
        this.pos = pos;
        this.newState = newState;
        this.moved = moved;
    }

    public BlockState getState() {
        return this.state;
    }

    public Level getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockState getNewState() {
        return this.newState;
    }

    public boolean isMoved() {
        return this.moved;
    }

    public boolean isClient() {
        return this.world.m_5776_();
    }

    public boolean isSameState() {
        return this.state.m_60713_(this.newState.m_60734_());
    }

    public boolean hasBlockEntity() {
        return WorldUtil.hasBlockEntity(this.world, this.pos);
    }

    public BlockEntity getBlockEntity() {
        return WorldUtil.getBlockEntity(this.world, this.pos);
    }

    public void spawnDropsInContainer() {
        if (this.isSameState() || !this.hasInventory()) {
            return;
        }
        ItemScattererUtil.spawn(this.getWorld(), this.getPos(), this.getBlockEntity());
        this.updateComparators();
    }

    public boolean hasInventory() {
        return this.getBlockEntity() instanceof Container;
    }

    public void updateComparators() {
        WorldUtil.updateComparators(this.getWorld(), this.getPos(), this.getState().m_60734_());
    }

    public World getMidohraWorld() {
        return World.of(this.world);
    }

    public IWorldView getWorldView() {
        return this.getMidohraWorld();
    }

    public net.pitan76.mcpitanlib.midohra.block.BlockState getMidohraState() {
        return net.pitan76.mcpitanlib.midohra.block.BlockState.of(this.state);
    }

    public net.pitan76.mcpitanlib.midohra.util.math.BlockPos getMidohraPos() {
        return net.pitan76.mcpitanlib.midohra.util.math.BlockPos.of(this.pos);
    }

    public BlockWrapper getBlockWrapper() {
        return BlockWrapper.of(this.state.m_60734_());
    }

    public BlockEntityWrapper getBlockEntityWrapper() {
        return BlockEntityWrapper.of(this.getBlockEntity());
    }
}

