/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.result;

import dev.architectury.event.CompoundEventResult;
import net.minecraft.world.InteractionResult;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import net.pitan76.mcpitanlib.api.util.StackActionResult;
import net.pitan76.mcpitanlib.midohra.item.ItemStack;

public class TypedEventResult<T> {
    protected final CompoundEventResult<T> result;

    protected TypedEventResult(CompoundEventResult<T> result) {
        this.result = result;
    }

    public static <T> TypedEventResult<T> success(T value) {
        return new TypedEventResult<T>(CompoundEventResult.interruptTrue(value));
    }

    public static <T> TypedEventResult<T> stop(T value) {
        return new TypedEventResult<T>(CompoundEventResult.interruptDefault(value));
    }

    public static <T> TypedEventResult<T> pass() {
        return new TypedEventResult<T>(CompoundEventResult.pass());
    }

    public static <T> TypedEventResult<T> fail(T value) {
        return new TypedEventResult<T>(CompoundEventResult.interruptFalse(value));
    }

    @Deprecated
    public CompoundEventResult<T> getResult() {
        return this.result;
    }

    public InteractionResult toActionResult() {
        return this.result.result().asMinecraft();
    }

    public CompatActionResult toCompatActionResult() {
        return CompatActionResult.of(this.result.result().asMinecraft());
    }

    public CompatActionResult toCompatActionResult(net.minecraft.world.item.ItemStack stack) {
        if (this.result.object() != stack) {
            return this.toCompatActionResult();
        }
        if (this.toActionResult() == InteractionResult.SUCCESS) {
            return StackActionResult.success(stack);
        }
        if (this.toActionResult() == InteractionResult.CONSUME) {
            return StackActionResult.consume(stack);
        }
        return this.toCompatActionResult();
    }

    public CompatActionResult toCompatActionResult(ItemStack stack) {
        return this.toCompatActionResult(stack.toMinecraft());
    }
}

