/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.gui.args;

import net.minecraft.world.inventory.ClickType;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.gui.slot.CompatSlotActionType;

public class SlotClickEvent {
    public int slot;
    public int button;
    public ClickType actionType;
    public Player player;

    public SlotClickEvent(int slot, int button, ClickType actionType, Player player) {
        this.slot = slot;
        this.button = button;
        this.actionType = actionType;
        this.player = player;
    }

    public int getSlot() {
        return this.slot;
    }

    public int getButton() {
        return this.button;
    }

    public ClickType getRawActionType() {
        return this.actionType;
    }

    public CompatSlotActionType getActionType() {
        return CompatSlotActionType.of(this.actionType);
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean isClient() {
        return this.player.isClient();
    }

    public boolean isServer() {
        return this.player.isServer();
    }

    public boolean isSwapAction() {
        return this.actionType == ClickType.SWAP;
    }

    public boolean isPickupAction() {
        return this.actionType == ClickType.PICKUP;
    }

    public boolean isQuickCraftAction() {
        return this.actionType == ClickType.QUICK_CRAFT;
    }

    public boolean isQuickMoveAction() {
        return this.actionType == ClickType.QUICK_MOVE;
    }

    public boolean isThrowAction() {
        return this.actionType == ClickType.THROW;
    }
}

