/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class PacketByteUtil {
    public static FriendlyByteBuf create() {
        return new FriendlyByteBuf(Unpooled.buffer());
    }

    public static FriendlyByteBuf empty() {
        return new FriendlyByteBuf(Unpooled.EMPTY_BUFFER);
    }

    public static <K, V> Map<K, V> readMap(FriendlyByteBuf buf, Function<FriendlyByteBuf, K> keyParser, Function<FriendlyByteBuf, V> valueParser) {
        return buf.m_178368_(keyParser, valueParser);
    }

    public static <K, V> void writeMap(FriendlyByteBuf buf, Map<K, V> map) {
        PacketByteUtil.writeMap(buf, map, PacketByteUtil::writeVar, PacketByteUtil::writeVar);
    }

    public static <K, V> void writeMap(FriendlyByteBuf buf, Map<K, V> map, BiConsumer<FriendlyByteBuf, K> keySerializer, BiConsumer<FriendlyByteBuf, V> valueSerializer) {
        buf.m_178355_(map, keySerializer, valueSerializer);
    }

    public static void writeVar(FriendlyByteBuf buf, Object obj) {
        if (obj instanceof String) {
            String s = (String)obj;
            buf.m_130070_(s);
        }
        if (obj instanceof Integer) {
            int i = (Integer)obj;
            buf.writeInt(i);
        }
        if (obj instanceof Long) {
            long l = (Long)obj;
            buf.writeLong(l);
        }
        if (obj instanceof Short) {
            short s = (Short)obj;
            buf.writeShort((int)s);
        }
        if (obj instanceof Boolean) {
            boolean b = (Boolean)obj;
            buf.writeBoolean(b);
        }
        if (obj instanceof Byte) {
            byte b = (Byte)obj;
            buf.writeByte((int)b);
        }
        if (obj instanceof CompoundTag) {
            CompoundTag nbt = (CompoundTag)obj;
            buf.m_130079_(nbt);
        }
        if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            buf.m_130055_(stack);
        }
        if (obj instanceof ResourceLocation) {
            ResourceLocation identifier = (ResourceLocation)obj;
            buf.m_130085_(identifier);
        }
        if (obj instanceof Float) {
            Float f = (Float)obj;
            buf.writeFloat(f.floatValue());
        }
        if (obj instanceof UUID) {
            UUID uuid = (UUID)obj;
            buf.m_130077_(uuid);
        }
        if (obj instanceof Component) {
            Component text = (Component)obj;
            buf.m_130083_(text);
        }
        if (obj instanceof BlockPos) {
            BlockPos pos = (BlockPos)obj;
            buf.m_130064_(pos);
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            PacketByteUtil.writeMap(buf, map);
        }
    }

    public static FriendlyByteBuf writeNbt(FriendlyByteBuf buf, CompoundTag nbt) {
        return buf.m_130079_(nbt);
    }

    public static CompoundTag readNbt(FriendlyByteBuf buf) {
        return buf.m_130260_();
    }

    public static FriendlyByteBuf writeItemStack(FriendlyByteBuf buf, ItemStack stack) {
        return buf.m_130055_(stack);
    }

    public static ItemStack readItemStack(FriendlyByteBuf buf) {
        return buf.m_130267_();
    }

    public static FriendlyByteBuf writeIdentifier(FriendlyByteBuf buf, ResourceLocation identifier) {
        return buf.m_130085_(identifier);
    }

    public static ResourceLocation readIdentifier(FriendlyByteBuf buf) {
        return buf.m_130281_();
    }

    public static FriendlyByteBuf writeText(FriendlyByteBuf buf, Component text) {
        return buf.m_130083_(text);
    }

    public static Component readText(FriendlyByteBuf buf) {
        return buf.m_130238_();
    }

    public static FriendlyByteBuf writeBlockPos(FriendlyByteBuf buf, BlockPos pos) {
        return buf.m_130064_(pos);
    }

    public static BlockPos readBlockPos(FriendlyByteBuf buf) {
        return buf.m_130135_();
    }

    public static FriendlyByteBuf writeUuid(FriendlyByteBuf buf, UUID uuid) {
        return buf.m_130077_(uuid);
    }

    public static UUID readUuid(FriendlyByteBuf buf) {
        return buf.m_130259_();
    }

    public static FriendlyByteBuf writeVarInt(FriendlyByteBuf buf, int i) {
        return buf.m_130130_(i);
    }

    public static int readVarInt(FriendlyByteBuf buf) {
        return buf.m_130242_();
    }

    public static FriendlyByteBuf writeVarLong(FriendlyByteBuf buf, long l) {
        return buf.m_130103_(l);
    }

    public static long readVarLong(FriendlyByteBuf buf) {
        return buf.m_130258_();
    }

    public static ByteBuf writeBoolean(FriendlyByteBuf buf, boolean b) {
        return buf.writeBoolean(b);
    }

    public static boolean readBoolean(FriendlyByteBuf buf) {
        return buf.readBoolean();
    }

    public static ByteBuf writeByte(FriendlyByteBuf buf, byte b) {
        return buf.writeByte((int)b);
    }

    public static byte readByte(FriendlyByteBuf buf) {
        return buf.readByte();
    }

    public static ByteBuf writeShort(FriendlyByteBuf buf, short s) {
        return buf.writeShort((int)s);
    }

    public static short readShort(FriendlyByteBuf buf) {
        return buf.readShort();
    }

    public static ByteBuf writeInt(FriendlyByteBuf buf, int i) {
        return buf.writeInt(i);
    }

    public static int readInt(FriendlyByteBuf buf) {
        return buf.readInt();
    }

    public static ByteBuf writeLong(FriendlyByteBuf buf, long l) {
        return buf.writeLong(l);
    }

    public static long readLong(FriendlyByteBuf buf) {
        return buf.readLong();
    }

    public static ByteBuf writeFloat(FriendlyByteBuf buf, float f) {
        return buf.writeFloat(f);
    }

    public static float readFloat(FriendlyByteBuf buf) {
        return buf.readFloat();
    }

    public static ByteBuf writeDouble(FriendlyByteBuf buf, double d) {
        return buf.writeDouble(d);
    }

    public static double readDouble(FriendlyByteBuf buf) {
        return buf.readDouble();
    }

    public static FriendlyByteBuf writeByteArray(FriendlyByteBuf buf, byte[] bytes) {
        return buf.m_130087_(bytes);
    }

    public static byte[] readByteArray(FriendlyByteBuf buf) {
        return buf.m_130052_();
    }

    public static FriendlyByteBuf writeString(FriendlyByteBuf buf, String s) {
        return buf.m_130070_(s);
    }

    public static String readString(FriendlyByteBuf buf) {
        return buf.m_130277_();
    }

    public static FriendlyByteBuf writeIntArray(FriendlyByteBuf buf, int[] ints) {
        return buf.m_130089_(ints);
    }

    public static int[] readIntArray(FriendlyByteBuf buf) {
        return buf.m_130100_();
    }

    public static FriendlyByteBuf writeLongArray(FriendlyByteBuf buf, long[] longs) {
        return buf.m_130091_(longs);
    }

    public static long[] readLongArray(FriendlyByteBuf buf) {
        return buf.m_178381_();
    }

    public static Tag readUnlimitedNbt(FriendlyByteBuf buf) {
        return buf.m_130081_(new NbtAccounter(Long.MAX_VALUE));
    }
}

