/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.ItemUtil;

public class IngredientUtil {
    public static Ingredient fromTagByIdentifier(ResourceLocation id) {
        return Ingredient.m_204132_((TagKey)TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)id));
    }

    public static Ingredient fromTagByString(String id) {
        return IngredientUtil.fromTagByIdentifier(new ResourceLocation(id));
    }

    public static Ingredient fromTagByIdentifier(CompatIdentifier id) {
        return IngredientUtil.fromTagByIdentifier(id.toMinecraft());
    }

    public static List<Item> getItems(Ingredient ingredient) {
        ArrayList<Item> items = new ArrayList<Item>();
        IntListIterator intListIterator = ingredient.m_43931_().iterator();
        while (intListIterator.hasNext()) {
            int rawId = (Integer)intListIterator.next();
            try {
                items.add(ItemUtil.fromIndex(rawId));
            }
            catch (Exception exception) {}
        }
        return items;
    }

    public static IntList getMatchingStacksIds(Ingredient ingredient) {
        return ingredient.m_43931_();
    }

    public static List<ItemStack> getMatchingStacksAsList(Ingredient ingredient) {
        return new ArrayList<ItemStack>(Arrays.asList(IngredientUtil.getMatchingStacks(ingredient)));
    }

    public static ItemStack[] getMatchingStacks(Ingredient ingredient) {
        return ingredient.m_43908_();
    }

    public static Ingredient empty() {
        return Ingredient.f_43901_;
    }

    public static Ingredient ofItems(ItemLike ... items) {
        return Ingredient.m_43929_((ItemLike[])items);
    }

    public static NonNullList<Ingredient> buildInput(Object[] input) {
        NonNullList list = NonNullList.m_122779_();
        for (Object obj : input) {
            if (obj instanceof Ingredient) {
                list.add((Object)((Ingredient)obj));
                continue;
            }
            if (!(obj instanceof ItemLike)) continue;
            list.add((Object)IngredientUtil.ofItems((ItemLike)obj));
        }
        return list;
    }
}

