/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.nbt.NbtRWArgs;
import net.pitan76.mcpitanlib.midohra.item.ItemWrapper;

public class ItemStackUtil {
    public static ItemStack copy(ItemStack stack) {
        return stack.m_41777_();
    }

    public static ItemStack copyWithCount(ItemStack stack, int count) {
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(count);
        return copy;
    }

    public static boolean areItemsEqual(ItemStack left, ItemStack right) {
        return ItemStack.m_41758_((ItemStack)left, (ItemStack)right);
    }

    @Deprecated
    public static boolean areNbtEqual(ItemStack left, ItemStack right) {
        return ItemStackUtil.areNbtOrComponentEqual(left, right);
    }

    public static boolean areNbtOrComponentEqual(ItemStack left, ItemStack right) {
        return Objects.equals(left.m_41783_(), right.m_41783_());
    }

    public static boolean hasNbtOrComponent(ItemStack stack) {
        return stack.m_41782_();
    }

    public static ItemStack fromNbt(Level world, CompoundTag nbt) {
        return ItemStack.m_41712_((CompoundTag)nbt);
    }

    public static ItemStack fromNbt(NbtRWArgs args) {
        return ItemStack.m_41712_((CompoundTag)args.getNbt());
    }

    public static ItemStack getDefaultStack(Item item) {
        return item.m_7968_();
    }

    public static int getMaxDamage(ItemStack stack) {
        return stack.m_41776_();
    }

    public static int getMaxDamage(Item item) {
        return ItemStackUtil.getMaxDamage(ItemStackUtil.getDefaultStack(item));
    }

    public static int getDamage(ItemStack stack) {
        return stack.m_41773_();
    }

    public static void setDamage(ItemStack stack, int damage) {
        stack.m_41721_(damage);
    }

    public static int getCount(ItemStack stack) {
        return stack.m_41613_();
    }

    public static void setCount(ItemStack stack, int count) {
        stack.m_41764_(count);
    }

    public static void decrementCount(ItemStack stack, int count) {
        stack.m_41774_(count);
    }

    public static void incrementCount(ItemStack stack, int count) {
        stack.m_41769_(count);
    }

    public static void damage(ItemStack stack, int amount, ServerPlayer entity, Runnable breakCallback) {
        stack.m_41622_(amount, (LivingEntity)entity, player -> breakCallback.run());
    }

    public static void damage(ItemStack stack, int amount, LivingEntity entity, EquipmentSlot slot) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer entity1 = (ServerPlayer)entity;
            ItemStackUtil.damage(stack, amount, entity1, () -> {});
        }
    }

    public static void damage(ItemStack stack, int amount, ServerPlayer entity) {
        stack.m_41622_(amount, (LivingEntity)entity, entity2 -> entity2.m_21166_(EquipmentSlot.MAINHAND));
    }

    public static void damage(ItemStack stack, int amount, Player entity) {
        Optional<ServerPlayer> player = entity.getServerPlayer();
        if (player.isEmpty()) {
            return;
        }
        ItemStackUtil.damage(stack, amount, player.get());
    }

    public static ItemStack empty() {
        return ItemStack.f_41583_;
    }

    public static ItemStack create(Item item) {
        if (item == null) {
            return ItemStackUtil.empty();
        }
        return new ItemStack((ItemLike)item);
    }

    public static ItemStack create(Item item, int count) {
        if (item == null) {
            return ItemStackUtil.empty();
        }
        return new ItemStack((ItemLike)item, count);
    }

    public static ItemStack create(ItemLike item) {
        if (item == null) {
            return ItemStackUtil.empty();
        }
        return new ItemStack(item);
    }

    public static ItemStack create(ItemLike item, int count) {
        if (item == null) {
            return ItemStackUtil.empty();
        }
        return new ItemStack(item, count);
    }

    public static boolean isEmpty(ItemStack stack) {
        if (stack == null) {
            return true;
        }
        return stack.m_41619_();
    }

    public static boolean isEnchantable(ItemStack stack) {
        return stack.m_41792_();
    }

    public static boolean isDamageable(ItemStack stack) {
        return stack.m_41763_();
    }

    public static boolean isBreak(ItemStack stack) {
        if (ItemStackUtil.isDamageable(stack)) {
            return ItemStackUtil.getDamage(stack) >= ItemStackUtil.getMaxDamage(stack);
        }
        return false;
    }

    public static ItemWrapper getItemWrapper(ItemStack stack) {
        return ItemWrapper.of(stack.m_41720_());
    }

    public static int getMaxCount(ItemStack stack) {
        return stack.m_41741_();
    }

    public static Item getItem(ItemStack stack) {
        return stack.m_41720_();
    }
}

