/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.item;

import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.pitan76.mcpitanlib.api.enchantment.CompatEnchantment;
import net.pitan76.mcpitanlib.api.item.stack.LoreUtil;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.CustomDataUtil;
import net.pitan76.mcpitanlib.api.util.EnchantmentUtil;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.ItemUtil;
import net.pitan76.mcpitanlib.api.util.NbtUtil;
import net.pitan76.mcpitanlib.midohra.item.ItemWrapper;
import org.jetbrains.annotations.Nullable;

public class ItemStack {
    private final net.minecraft.world.item.ItemStack stack;
    public static final ItemStack EMPTY = new ItemStack(ItemStackUtil.empty());

    protected ItemStack(net.minecraft.world.item.ItemStack stack) {
        this.stack = stack;
    }

    public static ItemStack of(net.minecraft.world.item.ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return EMPTY;
        }
        return new ItemStack(stack);
    }

    public static ItemStack of(ItemLike item) {
        return new Builder().item(item).build();
    }

    public static ItemStack of(ItemLike item, int count) {
        return new Builder().item(item).count(count).build();
    }

    public static ItemStack empty() {
        return EMPTY;
    }

    public int getCount() {
        return this.stack.m_41613_();
    }

    public void setCount(int count) {
        this.stack.m_41764_(count);
    }

    public CompoundTag getCustomNbt() {
        return CustomDataUtil.getNbt(this.stack);
    }

    public void setCustomNbt(CompoundTag nbt) {
        CustomDataUtil.setNbt(this.stack, nbt);
    }

    public void removeCustomNbt() {
        CustomDataUtil.remove(this.stack);
    }

    public boolean hasCustomNbt() {
        return CustomDataUtil.hasNbt(this.stack);
    }

    public boolean isEmpty() {
        return this.stack.m_41619_();
    }

    public CompatIdentifier getItemId() {
        return ItemUtil.toCompatID(this.stack.m_41720_());
    }

    public ItemStack copy() {
        return new ItemStack(this.stack.m_41777_());
    }

    public ItemStack copyWithCount(int count) {
        return new ItemStack(ItemStackUtil.copyWithCount(this.stack, count));
    }

    public Map<CompatEnchantment, Integer> getEnchantments(@Nullable Level world) {
        return EnchantmentUtil.getEnchantment(this.stack, world);
    }

    public void setEnchantments(Map<CompatEnchantment, Integer> enchantments, @Nullable Level world) {
        EnchantmentUtil.setEnchantment(this.stack, enchantments, world);
    }

    public int getMaxCount() {
        return ItemStackUtil.getMaxCount(this.stack);
    }

    public boolean hasLore() {
        return LoreUtil.hasLore(this.stack);
    }

    public List<Component> getLore() {
        return LoreUtil.getLore(this.stack);
    }

    public List<String> getLoreAsStringList() {
        return LoreUtil.getLoreAsStringList(this.stack);
    }

    public void setLore(List<Component> lore) {
        LoreUtil.setLore(this.stack, lore);
    }

    public void setLoreString(List<String> lore) {
        LoreUtil.setLoreStringList(this.stack, lore);
    }

    public void setLore(String lore) {
        LoreUtil.setLore(this.stack, lore);
    }

    @Deprecated
    public net.minecraft.world.item.ItemStack toMinecraft() {
        return this.stack;
    }

    public ItemWrapper getItem() {
        if (this.isEmpty()) {
            return ItemWrapper.of();
        }
        return ItemWrapper.of(this.getRawItem());
    }

    public Item getRawItem() {
        return ItemStackUtil.getItem(this.stack);
    }

    public String toString() {
        return this.stack.toString();
    }

    public static class Builder {
        protected CompatIdentifier id;
        protected int count = 1;
        protected CompoundTag nbt = NbtUtil.create();

        public Builder item(CompatIdentifier id) {
            this.id = id;
            return this;
        }

        public Builder item(ItemLike item) {
            this.id = ItemUtil.toCompatID(item.m_5456_());
            return this;
        }

        public Builder count(int count) {
            this.count = count;
            return this;
        }

        public Builder nbt(CompoundTag nbt) {
            this.nbt = nbt;
            return this;
        }

        public ItemStack build() {
            net.minecraft.world.item.ItemStack stack = new net.minecraft.world.item.ItemStack((ItemLike)ItemUtil.fromId(this.id), this.count);
            CustomDataUtil.setNbt(stack, this.nbt);
            return new ItemStack(stack);
        }
    }
}

