/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.LoggerUtil;
import net.pitan76.mcpitanlib.api.util.ResourceUtil;
import net.pitan76.mcpitanlib.midohra.resource.Resource;
import net.pitan76.mcpitanlib.midohra.server.MCServer;
import net.pitan76.mcpitanlib.midohra.world.WorldAccess;

public class ResourceManager {
    private final net.minecraft.server.packs.resources.ResourceManager resourceManager;

    protected ResourceManager(net.minecraft.server.packs.resources.ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public static ResourceManager of(net.minecraft.server.packs.resources.ResourceManager resourceManager) {
        return new ResourceManager(resourceManager);
    }

    public static ResourceManager of(MinecraftServer server) {
        return ResourceManager.of(MCServer.of(server));
    }

    public static ResourceManager of(MCServer server) {
        return ResourceManager.of(server.getRaw());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ResourceManager of(Minecraft client) {
        return ResourceManager.of(client.m_91098_());
    }

    public static ResourceManager of(LevelAccessor worldAccess) {
        return ResourceManager.of(worldAccess.m_142572_());
    }

    public static ResourceManager of(WorldAccess worldAccess) {
        return ResourceManager.of(worldAccess.getServer());
    }

    public net.minecraft.server.packs.resources.ResourceManager getRaw() {
        return this.resourceManager;
    }

    public net.minecraft.server.packs.resources.ResourceManager toMinecraft() {
        return this.getRaw();
    }

    public Map<CompatIdentifier, Resource> findResources(String startPath, String endPath) {
        HashMap<CompatIdentifier, Resource> map = new HashMap<CompatIdentifier, Resource>();
        try {
            Map<ResourceLocation, net.minecraft.server.packs.resources.Resource> rawMap = ResourceUtil.findResources(this.resourceManager, startPath, endPath);
            for (Map.Entry<ResourceLocation, net.minecraft.server.packs.resources.Resource> entry : rawMap.entrySet()) {
                map.put(CompatIdentifier.fromMinecraft(entry.getKey()), Resource.of(entry.getValue()));
            }
        }
        catch (IOException e) {
            LoggerUtil.error(LoggerUtil.getLogger(), "Failed to read " + startPath + ": " + e.getMessage());
            return null;
        }
        return map;
    }

    public Resource getResource(CompatIdentifier id) {
        try {
            return Resource.of(this.resourceManager.m_142591_(id.toMinecraft()));
        }
        catch (IOException e) {
            return null;
        }
    }

    public List<Resource> getAllResources(CompatIdentifier id) {
        try {
            return this.resourceManager.m_7396_(id.toMinecraft()).stream().map(Resource::of).toList();
        }
        catch (IOException e) {
            return null;
        }
    }
}

