/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class TextConverter {
    public static MutableComponent convert(String string) {
        return TextConverter.convert(string, false);
    }

    public static MutableComponent convert(String text, boolean translatable) {
        String[] splits = TextConverter.split(text);
        TextComponent result = new TextComponent("");
        ChatFormatting[] currentFormatting = new ChatFormatting[]{};
        for (String part : splits) {
            if (part.startsWith("\u00a7") && part.length() == 2) {
                char code = part.charAt(1);
                if (code == 'r') {
                    currentFormatting = new ChatFormatting[]{};
                    continue;
                }
                ChatFormatting format = ChatFormatting.m_126645_((char)code);
                if (format == null) continue;
                if (code >= 'k' && code <= 'o') {
                    ArrayList<ChatFormatting> list = new ArrayList<ChatFormatting>(Arrays.asList(currentFormatting));
                    list.add(format);
                    currentFormatting = list.toArray(new ChatFormatting[0]);
                    continue;
                }
                currentFormatting = new ChatFormatting[]{format};
                continue;
            }
            if (translatable) {
                Pattern pattern = Pattern.compile("\\{(.+?)\\}");
                Matcher matcher = pattern.matcher(part);
                TextComponent tempText = new TextComponent("");
                int lastIndex = 0;
                while (matcher.find()) {
                    if (matcher.start() > lastIndex) {
                        tempText.m_7220_((Component)new TextComponent(part.substring(lastIndex, matcher.start())).m_130944_(currentFormatting));
                    }
                    String key = matcher.group(1);
                    tempText.m_7220_((Component)new TranslatableComponent(key).m_130944_(currentFormatting));
                    lastIndex = matcher.end();
                }
                if (lastIndex < part.length()) {
                    tempText.m_7220_((Component)new TextComponent(part.substring(lastIndex)).m_130944_(currentFormatting));
                }
                result.m_7220_((Component)tempText);
                continue;
            }
            result.m_7220_((Component)new TextComponent(part).m_130944_(currentFormatting));
        }
        return result;
    }

    public static String[] split(String text) {
        Matcher matcher = Pattern.compile("(?i)\u00a7[0-9a-fk-or]|[^\u00a7]+").matcher(text);
        ArrayList<String> parts = new ArrayList<String>();
        while (matcher.find()) {
            parts.add(matcher.group());
        }
        return parts.toArray(new String[0]);
    }
}

