/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.pitan76.mcpitanlib.api.recipe.CompatRecipeType;
import net.pitan76.mcpitanlib.api.recipe.MatchGetter;
import net.pitan76.mcpitanlib.api.recipe.input.CompatRecipeInput;
import net.pitan76.mcpitanlib.api.recipe.v2.CompatRecipeEntry;
import net.pitan76.mcpitanlib.api.recipe.v2.CompatRecipeNonEntry;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.IdentifierUtil;
import net.pitan76.mcpitanlib.api.util.IngredientUtil;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.RegistryLookupUtil;
import net.pitan76.mcpitanlib.api.util.collection.ItemStackList;

public class RecipeUtil {
    public static ShapelessRecipe createShapelessRecipe(ResourceLocation id, String group, CompatibilityCraftingRecipeCategory category, ItemStack output, NonNullList<Ingredient> input) {
        return RecipeUtil.createShapelessRecipe(id, group, output, input);
    }

    public static ShapelessRecipe createShapelessRecipe(ResourceLocation id, String group, ItemStack output, NonNullList<Ingredient> input) {
        return new ShapelessRecipe(id, group, output, input);
    }

    public static <C extends Container> ItemStack craft_2(Recipe<C> recipe, C inventory, Level world) {
        return recipe.m_5874_(inventory);
    }

    public static <C extends Container> ItemStack getOutput_2(Recipe<C> recipe, Level world) {
        return recipe.m_8043_();
    }

    public static ItemStack craft(Recipe<?> recipe, Container inventory, Level world) {
        if (inventory instanceof CraftingContainer) {
            Recipe<?> inputRecipe = recipe;
            return inputRecipe.m_5874_((Container)((CraftingContainer)inventory));
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getOutput(Recipe<?> recipe, Level world) {
        return RecipeUtil.getOutput(recipe, RegistryLookupUtil.getRegistryLookup(world));
    }

    public static List<Recipe<?>> getAllRecipes(Level world) {
        Collection recipes = world.m_7465_().m_44051_();
        return new ArrayList(recipes);
    }

    public static List<CompatRecipeNonEntry<?>> getAllCompatRecipeEntry(Level world) {
        List<Recipe<?>> recipes = RecipeUtil.getAllRecipes(world);
        ArrayList outRecipes = new ArrayList();
        for (Recipe<?> recipe : recipes) {
            outRecipes.add(new CompatRecipeNonEntry(recipe));
        }
        return outRecipes;
    }

    public static RecipeType<?> getType(Recipe<?> recipe) {
        return recipe.m_6671_();
    }

    public static ResourceLocation getId(Recipe<?> recipe) {
        return IdentifierUtil.id("" + recipe.getClass().hashCode());
    }

    public static <I extends Container, T extends Recipe<I>> CompatRecipeEntry<I> getFirstMatch(RecipeManager recipeManager, CompatRecipeType<T> type, CompatRecipeInput<I> input, Level world) {
        Optional recipe = recipeManager.m_44015_(type.getType(), input.getInput(), world);
        return recipe.map(CompatRecipeEntry::new).orElseGet(() -> new CompatRecipeEntry(null));
    }

    public static <I extends Container, T extends Recipe<I>> CompatRecipeEntry<I> getFirstMatch(RecipeManager recipeManager, CompatRecipeType<T> type, CompatRecipeInput<I> input, Level world, CompatIdentifier identifier) {
        return RecipeUtil.getFirstMatch(recipeManager, type, input, world);
    }

    public static <I extends Container, T extends Recipe<I>> CompatRecipeEntry<I> getFirstMatch(Level world, CompatRecipeType<T> type, CompatRecipeInput<I> input) {
        return RecipeUtil.getFirstMatch(RecipeUtil.getRecipeManager(world), type, input, world);
    }

    public static <I extends Container, T extends Recipe<I>> CompatRecipeEntry<I> getFirstMatch(Level world, CompatRecipeType<T> type, CompatRecipeInput<I> input, CompatIdentifier identifier) {
        return RecipeUtil.getFirstMatch(RecipeUtil.getRecipeManager(world), type, input, world, identifier);
    }

    public static RecipeManager getRecipeManager(Level world) {
        return world.m_7465_();
    }

    public Optional<Recipe<?>> get(Level world, CompatIdentifier id) {
        return this.get(RecipeUtil.getRecipeManager(world), id);
    }

    public Optional<Recipe<?>> get(RecipeManager recipeManager, CompatIdentifier id) {
        return recipeManager.m_44043_(id.toMinecraft());
    }

    public static <I extends Container, T extends Recipe<I>> MatchGetter<I, T> createCachedMatchGetter(RecipeType<T> type) {
        return (input, world) -> {
            Optional optional = RecipeUtil.getRecipeManager(world).m_44015_(type, input.getInput(), world);
            return Optional.of(optional.map(CompatRecipeEntry::new).orElseGet(() -> new CompatRecipeEntry(null)));
        };
    }

    public static <I extends Container, T extends Recipe<I>> MatchGetter<I, T> createCachedMatchGetter(CompatRecipeType<T> type) {
        return RecipeUtil.createCachedMatchGetter(type.getType());
    }

    public static NonNullList<Ingredient> getInputs(Recipe<?> recipe) {
        return recipe.m_7527_();
    }

    public static NonNullList<Ingredient> getInputs(CompatRecipeEntry<?> recipeEntry) {
        return RecipeUtil.getInputs(recipeEntry.getRecipe());
    }

    public static ItemStackList getInputsAsStack(Recipe<?> recipe) {
        NonNullList<Ingredient> ingredients = RecipeUtil.getInputs(recipe);
        ItemStackList stacks = ItemStackList.ofSize(ingredients.size(), ItemStackUtil.empty());
        for (Ingredient ingredient : ingredients) {
            stacks.addAll(IngredientUtil.getMatchingStacksAsList(ingredient));
        }
        return stacks;
    }

    public static ItemStackList getInputsAsStack(CompatRecipeEntry<?> recipeEntry) {
        return RecipeUtil.getInputsAsStack(recipeEntry.getRecipe());
    }

    public static ItemStack getOutput(Recipe<?> recipe, CompatRegistryLookup registryLookup) {
        return recipe.m_8043_();
    }

    public static ItemStack getOutput(CompatRecipeEntry<?> recipeEntry, CompatRegistryLookup registryLookup) {
        return RecipeUtil.getOutput(recipeEntry.getRecipe(), registryLookup);
    }

    public static CompatRecipeType<?> getType(CompatRecipeEntry<?> recipeEntry) {
        return CompatRecipeType.of(recipeEntry.getRecipe().m_6671_());
    }

    public static <I extends Container, T extends Recipe<I>> ItemStackList getRemainder(CompatRecipeEntry<I> recipeEntry, CompatRecipeInput<I> input) {
        return ItemStackList.of((NonNullList<ItemStack>)recipeEntry.getRecipe().m_7457_(input.getInput()));
    }

    public static enum CompatibilityCraftingRecipeCategory {
        BUILDING,
        REDSTONE,
        EQUIPMENT,
        MISC;

    }
}

