/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.inventory.ICompatInventory;

public class ClippedInventory
implements Container,
ICompatInventory {
    private final Container inventory;
    private final int start;
    private final int end;

    public static ClippedInventory of(Container inventory, int start, int end) {
        if (start < 0 || end > inventory.m_6643_() || start >= end) {
            throw new IllegalArgumentException("Invalid start or end indices for clipping inventory.");
        }
        return new ClippedInventory(inventory, start, end);
    }

    public static ClippedInventory of(Container inventory) {
        return ClippedInventory.of(inventory, 0, inventory.m_6643_());
    }

    public static ClippedInventory of(Container inventory, int start) {
        return ClippedInventory.of(inventory, start, inventory.m_6643_());
    }

    public ClippedInventory(Container inventory, int start, int end) {
        this.inventory = inventory;
        this.start = start;
        this.end = end;
    }

    public int m_6643_() {
        return this.end - this.start;
    }

    public boolean m_7983_() {
        for (int i = this.start; i < this.end; ++i) {
            if (this.inventory.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return this.inventory.m_8020_(this.start + slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return this.inventory.m_7407_(this.start + slot, amount);
    }

    public ItemStack m_8016_(int slot) {
        return this.inventory.m_8016_(this.start + slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.inventory.m_6836_(this.start + slot, stack);
    }

    public void m_6596_() {
        this.inventory.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return this.inventory.m_6542_(player);
    }

    public void m_6211_() {
        for (int i = this.start; i < this.end; ++i) {
            this.inventory.m_6836_(i, ItemStackUtil.empty());
        }
    }

    public int m_6893_() {
        return this.inventory.m_6893_();
    }
}

