/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.math.random;

import java.util.Random;

public class CompatRandom {
    private final Random javaRandom;

    public CompatRandom(Random javaRandom) {
        this.javaRandom = javaRandom;
    }

    @Deprecated
    public CompatRandom() {
        this.javaRandom = new Random();
    }

    @Deprecated
    public CompatRandom(long seed) {
        this.javaRandom = new Random(seed);
    }

    public static CompatRandom of(long seed) {
        return new CompatRandom(seed);
    }

    public static CompatRandom of() {
        return new CompatRandom();
    }

    public void setSeed(long seed) {
        this.javaRandom.setSeed(seed);
    }

    public void skip(int count) {
        for (int i = 0; i < count; ++i) {
            this.javaRandom.nextInt();
        }
    }

    public void split() {
        this.javaRandom.nextInt();
    }

    public int nextInt() {
        return this.javaRandom.nextInt();
    }

    public int nextInt(int bound) {
        return this.javaRandom.nextInt(bound);
    }

    public long nextLong() {
        return this.javaRandom.nextLong();
    }

    public double nextDouble() {
        return this.javaRandom.nextDouble();
    }

    public double nextGaussian() {
        return this.javaRandom.nextGaussian();
    }

    public float nextFloat() {
        return this.javaRandom.nextFloat();
    }

    public int nextBetween(int min, int max) {
        return min + this.javaRandom.nextInt(max - min);
    }

    public int nextBetweenExclusive(int min, int max) {
        return min + this.javaRandom.nextInt(max - min + 1);
    }

    public boolean nextBoolean() {
        return this.javaRandom.nextBoolean();
    }

    @Deprecated
    public Random getJavaRandom() {
        return this.javaRandom;
    }
}

