/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.world.chunk;

import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Unit;
import net.minecraft.world.level.ChunkPos;

public class ChunkTicketType<T> {
    public static final ChunkTicketType<Unit> START = ChunkTicketType.of(TicketType.f_9442_);
    public static final ChunkTicketType<Unit> DRAGON = ChunkTicketType.of(TicketType.f_9443_);
    public static final ChunkTicketType<ChunkPos> PLAYER = ChunkTicketType.of(TicketType.f_9444_);
    public static final ChunkTicketType<ChunkPos> FORCED = ChunkTicketType.of(TicketType.f_9445_);
    public static final ChunkTicketType<BlockPos> PORTAL = ChunkTicketType.of(TicketType.f_9447_);
    public static final ChunkTicketType<ChunkPos> ENDER_PEARL = ChunkTicketType.of(TicketType.f_9449_);
    public static final ChunkTicketType<Integer> POST_TELEPORT = ChunkTicketType.of(TicketType.f_9448_);
    public static final ChunkTicketType<ChunkPos> UNKNOWN = ChunkTicketType.of(TicketType.f_9449_);
    private final TicketType<T> ticketType;

    protected ChunkTicketType(TicketType<T> ticketType) {
        this.ticketType = ticketType;
    }

    public static <T> ChunkTicketType<T> of(TicketType<T> ticketType) {
        return new ChunkTicketType<T>(ticketType);
    }

    public TicketType<T> getRaw() {
        return this.ticketType;
    }

    public TicketType<T> toMinecraft() {
        return this.getRaw();
    }

    public static <T> ChunkTicketType<T> create(String name, Comparator<T> argumentComparator) {
        return ChunkTicketType.of(TicketType.m_9462_((String)name, argumentComparator));
    }

    public static <T> ChunkTicketType<T> create(String name, Comparator<T> argumentComparator, int expiryTicks) {
        return ChunkTicketType.of(TicketType.m_9465_((String)name, argumentComparator, (int)expiryTicks));
    }

    public Comparator<T> getArgumentComparator() {
        return this.getRaw().m_9458_();
    }

    public long getExpiryTicks() {
        return this.getRaw().m_9469_();
    }

    public String toString() {
        return this.getRaw().toString();
    }

    public ChunkTicketType(String name, long expiryTicks) {
        this(ChunkTicketType._of(name, expiryTicks));
    }

    public ChunkTicketType(String name) {
        this(name, 0L);
    }

    public static ChunkTicketType<ChunkPos> create(String name, long expiryTicks) {
        return new ChunkTicketType<ChunkPos>(name, expiryTicks);
    }

    public static ChunkTicketType<ChunkPos> create(String name) {
        return new ChunkTicketType<ChunkPos>(name);
    }

    private static <T> TicketType<T> _of(String name, long expiryTicks) {
        TicketType type = TicketType.m_9465_((String)name, Comparator.comparingLong(ChunkPos::m_45588_), (int)((int)expiryTicks));
        return type;
    }

    public int hashCode() {
        return this.ticketType.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChunkTicketType)) {
            return false;
        }
        ChunkTicketType that = (ChunkTicketType)obj;
        return this.ticketType.equals(that.ticketType);
    }
}

