/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.item;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_4174;
import net.pitan76.mcpitanlib.api.entity.effect.CompatStatusEffectInstance;

public class CompatFoodComponent {
    private int hunger;
    private float saturation;
    private boolean meat;
    private boolean alwaysEdible;
    private boolean snack;
    private final List<Pair<class_1293, Float>> statusEffects = new ArrayList<Pair<class_1293, Float>>();
    private class_4174 latestComponent = null;

    public static CompatFoodComponent create() {
        return new CompatFoodComponent();
    }

    public CompatFoodComponent setHunger(int hunger) {
        this.hunger = hunger;
        return this;
    }

    public CompatFoodComponent setSaturation(float saturation) {
        this.saturation = saturation;
        return this;
    }

    public CompatFoodComponent setAlwaysEdible() {
        this.alwaysEdible = true;
        return this;
    }

    public CompatFoodComponent setSnack() {
        this.snack = true;
        return this;
    }

    public CompatFoodComponent setMeat() {
        this.meat = true;
        return this;
    }

    @Deprecated
    public CompatFoodComponent addStatusEffect(class_1293 effect, float chance) {
        this.statusEffects.add((Pair<class_1293, Float>)Pair.of((Object)effect, (Object)Float.valueOf(chance)));
        return this;
    }

    public CompatFoodComponent addStatusEffect(CompatStatusEffectInstance instance, float chance) {
        return this.addStatusEffect(instance.getInstance(), chance);
    }

    public class_4174.class_4175 getVanillaBuilder() {
        class_4174.class_4175 builder = new class_4174.class_4175();
        builder.method_19238(this.hunger).method_19237(this.saturation);
        if (this.alwaysEdible) {
            builder.method_19240();
        }
        if (this.snack) {
            builder.method_19241();
        }
        for (Pair<class_1293, Float> pair : this.statusEffects) {
            builder.method_19239((class_1293)pair.getFirst(), ((Float)pair.getSecond()).floatValue());
        }
        return builder;
    }

    public class_4174 build() {
        if (this.latestComponent != null) {
            return this.latestComponent;
        }
        float eatSeconds = 1.6f;
        ImmutableList.Builder effects = ImmutableList.builder();
        effects.addAll(this.statusEffects.stream().map(pair -> new class_4174.class_9423((class_1293)pair.getFirst(), ((Float)pair.getSecond()).floatValue())).iterator());
        if (this.snack) {
            eatSeconds = 0.8f;
        }
        if (this.meat) {
            eatSeconds = 1.6f;
        }
        this.latestComponent = new class_4174(this.hunger, this.saturation, this.alwaysEdible, eatSeconds, Optional.empty(), (List)effects.build());
        return this.latestComponent;
    }

    public class_4174 vanillaBuild() {
        if (this.latestComponent != null) {
            return this.latestComponent;
        }
        this.latestComponent = this.getVanillaBuilder().method_19242();
        return this.latestComponent;
    }

    public int getHunger() {
        return this.hunger;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public boolean isMeat() {
        return this.meat;
    }

    public boolean isSnack() {
        return this.snack;
    }

    public boolean isAlwaysEdible() {
        return this.alwaysEdible;
    }

    @Deprecated
    public List<Pair<class_1293, Float>> getStatusEffects() {
        return this.statusEffects;
    }

    public List<Pair<CompatStatusEffectInstance, Float>> getCompatStatusEffects() {
        ArrayList<Pair<CompatStatusEffectInstance, Float>> compatStatusEffects = new ArrayList<Pair<CompatStatusEffectInstance, Float>>();
        for (Pair<class_1293, Float> pair : this.statusEffects) {
            compatStatusEffects.add((Pair<CompatStatusEffectInstance, Float>)Pair.of((Object)new CompatStatusEffectInstance((class_1293)pair.getFirst()), (Object)((Float)pair.getSecond())));
        }
        return compatStatusEffects;
    }
}

