/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.client.gui.widget;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.pitan76.mcpitanlib.api.client.render.handledscreen.RenderArgs;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SimpleListWidget
extends ContainerObjectSelectionList<WidgetEntry> {
    public SimpleListWidget(Minecraft client, int width, int height, int top, int bottom, int itemHeight) {
        this(client, width, bottom - top, top, itemHeight);
    }

    public SimpleListWidget(Minecraft client, int width, int height, int y, int itemHeight) {
        super(client, width, height, y, itemHeight);
        this.centerListVertically = false;
    }

    public void add(AbstractWidget widget) {
        super.addEntry((AbstractSelectionList.Entry)WidgetEntry.create(widget));
    }

    public int getRowWidth() {
        return 400;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 32;
    }

    @Nullable
    public AbstractWidget getWidget(int index) {
        if (index < 0 || index >= this.children().size()) {
            return null;
        }
        return ((WidgetEntry)((Object)this.children().get(index))).getWidget();
    }

    public Optional<AbstractWidget> getHoveredWidget(double mouseX, double mouseY) {
        for (WidgetEntry entry : this.children()) {
            if (!entry.getWidget().isMouseOver(mouseX, mouseY)) continue;
            return Optional.of(entry.getWidget());
        }
        return Optional.empty();
    }

    public void render(RenderArgs args) {
        super.render(args.drawObjectDM.getContext(), args.mouseX, args.mouseY, args.delta);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WidgetEntry
    extends ContainerObjectSelectionList.Entry<WidgetEntry> {
        protected final AbstractWidget widget;

        public WidgetEntry(AbstractWidget widget) {
            this.widget = widget;
        }

        public static WidgetEntry create(AbstractWidget widget) {
            return new WidgetEntry(widget);
        }

        @Deprecated
        public void render(GuiGraphics matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.widget.setY(y);
            this.widget.render(matrices, mouseX, mouseY, tickDelta);
        }

        @Deprecated
        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.widget);
        }

        @Deprecated
        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.widget);
        }

        public AbstractWidget getWidget() {
            return this.widget;
        }
    }
}

