/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.item.v3;

import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.pitan76.mcpitanlib.api.item.v3.CompatToolMaterial;
import net.pitan76.mcpitanlib.api.tag.item.RepairIngredientTag;

public class VanillaCompatToolMaterial
implements CompatToolMaterial {
    private final Tier material;
    public static final VanillaCompatToolMaterial WOOD = VanillaCompatToolMaterial.of((Tier)Tiers.WOOD);
    public static final VanillaCompatToolMaterial STONE = VanillaCompatToolMaterial.of((Tier)Tiers.STONE);
    public static final VanillaCompatToolMaterial IRON = VanillaCompatToolMaterial.of((Tier)Tiers.IRON);
    public static final VanillaCompatToolMaterial GOLD = VanillaCompatToolMaterial.of((Tier)Tiers.GOLD);
    public static final VanillaCompatToolMaterial DIAMOND = VanillaCompatToolMaterial.of((Tier)Tiers.DIAMOND);
    public static final VanillaCompatToolMaterial NETHERITE = VanillaCompatToolMaterial.of((Tier)Tiers.NETHERITE);

    protected VanillaCompatToolMaterial(Tier material) {
        this.material = material;
    }

    private static VanillaCompatToolMaterial of(Tier material) {
        return new VanillaCompatToolMaterial(material);
    }

    @Override
    public RepairIngredientTag getRepairIngredientTag() {
        if (this.material == Tiers.STONE) {
            return RepairIngredientTag.STONE_TOOL_MATERIALS;
        }
        if (this.material == Tiers.IRON) {
            return RepairIngredientTag.IRON_TOOL_MATERIALS;
        }
        if (this.material == Tiers.GOLD) {
            return RepairIngredientTag.GOLDEN_TOOL_MATERIALS;
        }
        if (this.material == Tiers.DIAMOND) {
            return RepairIngredientTag.DIAMOND_TOOL_MATERIALS;
        }
        if (this.material == Tiers.NETHERITE) {
            return RepairIngredientTag.NETHERITE_TOOL_MATERIALS;
        }
        return RepairIngredientTag.WOODEN_TOOL_MATERIALS;
    }

    @Override
    public int getCompatDurability() {
        return this.material.getUses();
    }

    @Override
    public float getCompatMiningSpeedMultiplier() {
        return this.material.getSpeed();
    }

    @Override
    public float getCompatAttackDamage() {
        return this.material.getAttackDamageBonus();
    }

    @Override
    public int getCompatMiningLevel() {
        TagKey tag = this.material.getIncorrectBlocksForDrops();
        if (tag == Tiers.WOOD.getIncorrectBlocksForDrops()) {
            return 0;
        }
        if (tag == Tiers.STONE.getIncorrectBlocksForDrops()) {
            return 1;
        }
        if (tag == Tiers.IRON.getIncorrectBlocksForDrops()) {
            return 2;
        }
        if (tag == Tiers.GOLD.getIncorrectBlocksForDrops()) {
            return 2;
        }
        if (tag == Tiers.DIAMOND.getIncorrectBlocksForDrops()) {
            return 3;
        }
        if (tag == Tiers.NETHERITE.getIncorrectBlocksForDrops()) {
            return 4;
        }
        return -1;
    }

    @Override
    public int getCompatEnchantability() {
        return this.material.getEnchantmentValue();
    }

    @Deprecated
    public Tier toMinecraft() {
        return this.material;
    }

    @Override
    public Tier build() {
        return this.material;
    }
}

