/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.crafting.Ingredient;
import net.pitan76.mcpitanlib.api.item.ArmorEquipmentType;
import net.pitan76.mcpitanlib.api.item.CompatibleArmorMaterial;
import net.pitan76.mcpitanlib.api.util.IdentifierUtil;

public class ArmorMaterialUtil {
    public static CompatibleArmorMaterial create(String name, int[] durability, int[] protectionAmounts, int enchantability, SoundEvent equipSound, float toughness, float knockbackResistance, Ingredient repairIngredient) {
        return ArmorMaterialUtil.create(IdentifierUtil.id(name), durability, protectionAmounts, enchantability, equipSound, toughness, knockbackResistance, repairIngredient);
    }

    public static CompatibleArmorMaterial create(String name, int durability, int protectionAmount, int enchantability, SoundEvent equipSound, float toughness, float knockbackResistance, Ingredient repairIngredient) {
        return ArmorMaterialUtil.create(IdentifierUtil.id(name), durability, protectionAmount, enchantability, equipSound, toughness, knockbackResistance, repairIngredient);
    }

    @Deprecated
    public static CompatibleArmorMaterial create(final ResourceLocation id, final int[] durability, final int[] protectionAmounts, final int enchantability, final SoundEvent equipSound, final float toughness, final float knockbackResistance, final Ingredient repairIngredient) {
        return new CompatibleArmorMaterial(){

            @Override
            public int getDurability(ArmorEquipmentType type) {
                switch (type.getSlot()) {
                    case HEAD: {
                        return durability[0];
                    }
                    case CHEST: {
                        return durability[1];
                    }
                    case LEGS: {
                        return durability[2];
                    }
                    case FEET: {
                        return durability[3];
                    }
                }
                return 0;
            }

            @Override
            public int getProtection(ArmorEquipmentType type) {
                switch (type.getSlot()) {
                    case HEAD: {
                        return protectionAmounts[0];
                    }
                    case CHEST: {
                        return protectionAmounts[1];
                    }
                    case LEGS: {
                        return protectionAmounts[2];
                    }
                    case FEET: {
                        return protectionAmounts[3];
                    }
                }
                return 0;
            }

            @Override
            public int getEnchantability() {
                return enchantability;
            }

            @Override
            public SoundEvent getEquipSound() {
                return equipSound;
            }

            @Override
            public Ingredient getRepairIngredient() {
                return repairIngredient;
            }

            @Override
            public ResourceLocation getId() {
                return id;
            }

            @Override
            public float getToughness() {
                return toughness;
            }

            @Override
            public float getKnockbackResistance() {
                return knockbackResistance;
            }
        };
    }

    @Deprecated
    public static CompatibleArmorMaterial create(final ResourceLocation id, final int durability, final int protectionAmount, final int enchantability, final SoundEvent equipSound, final float toughness, final float knockbackResistance, final Ingredient repairIngredient) {
        return new CompatibleArmorMaterial(){

            @Override
            public int getDurability(ArmorEquipmentType type) {
                return durability;
            }

            @Override
            public int getProtection(ArmorEquipmentType type) {
                return protectionAmount;
            }

            @Override
            public int getEnchantability() {
                return enchantability;
            }

            @Override
            public SoundEvent getEquipSound() {
                return equipSound;
            }

            @Override
            public Ingredient getRepairIngredient() {
                return repairIngredient;
            }

            @Override
            public ResourceLocation getId() {
                return id;
            }

            @Override
            public float getToughness() {
                return toughness;
            }

            @Override
            public float getKnockbackResistance() {
                return knockbackResistance;
            }
        };
    }
}

