/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.collection;

import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.collection.ItemStackList;
import net.pitan76.mcpitanlib.api.util.inventory.ClippedInventory;
import org.jetbrains.annotations.NotNull;

public class ClippedItemStackList
extends ItemStackList {
    public final ItemStackList list;
    public final int start;
    public final int end;

    public ClippedItemStackList(ItemStackList list, int start, int end) {
        super(null, null);
        this.list = list;
        if (start < 0 || end > list.size() || start >= end) {
            throw new IllegalArgumentException("Invalid start or end indices for clipping item stack list.");
        }
        this.start = start;
        this.end = end;
    }

    public static ClippedItemStackList of(ItemStackList list, int start, int end) {
        return new ClippedItemStackList(list, start, end);
    }

    public static ClippedItemStackList of(ItemStackList list) {
        return ClippedItemStackList.of(list, 0, list.size());
    }

    public static ClippedItemStackList of(ItemStackList list, int start) {
        return ClippedItemStackList.of(list, start, list.size());
    }

    public int size() {
        return this.end - this.start;
    }

    @Override
    public Container toInventory() {
        return ClippedInventory.of(this.list.toInventory(), this.start, this.end);
    }

    @Override
    public NonNullList<ItemStack> defaultedList() {
        NonNullList clippedList = NonNullList.withSize((int)this.size(), (Object)ItemStackUtil.empty());
        for (int i = 0; i < this.size(); ++i) {
            clippedList.set(i, (Object)this.get(i));
        }
        return clippedList;
    }

    @NotNull
    public ItemStack get(int index) {
        return (ItemStack)this.list.get(this.start + index);
    }

    public ItemStack set(int index, ItemStack element) {
        return (ItemStack)this.list.set(this.start + index, element);
    }

    public ItemStack remove(int index) {
        return (ItemStack)this.list.remove(this.start + index);
    }

    public boolean contains(Object o) {
        for (int i = this.start; i < this.end; ++i) {
            if (!((ItemStack)this.list.get(i)).equals(o)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        for (int i = this.start; i < this.end; ++i) {
            if (((ItemStack)this.list.get(i)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        for (int i = this.start; i < this.end; ++i) {
            this.list.set(i, ItemStackUtil.empty());
        }
    }
}

