/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.recipe.input;

import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.crafting.CraftingInput;
import net.pitan76.mcpitanlib.api.recipe.input.CompatRecipeInput;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.midohra.item.ItemStack;

public class CraftingRecipeInputUtil {
    public static Optional<CraftingInput> get(CompatRecipeInput<?> input) {
        if (input.getInput() instanceof CraftingInput) {
            return Optional.of((CraftingInput)input.getInput());
        }
        return Optional.empty();
    }

    public static CompatRecipeInput<?> create(CraftingInput input) {
        return new CompatRecipeInput<CraftingInput>(input);
    }

    public static CompatRecipeInput<?> create(int width, int height, List<net.minecraft.world.item.ItemStack> stacks) {
        return new CompatRecipeInput<CraftingInput>(CraftingInput.of((int)width, (int)height, stacks));
    }

    public static net.minecraft.world.item.ItemStack getStack(CraftingInput input, int x, int y) {
        return input.getItem(x, y);
    }

    public static net.minecraft.world.item.ItemStack getStack(CompatRecipeInput<?> input, int x, int y) {
        Optional<CraftingInput> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return ItemStackUtil.empty();
        }
        return CraftingRecipeInputUtil.getStack(recipeInput.get(), x, y);
    }

    public static ItemStack getMidohraStack(CompatRecipeInput<?> input, int x, int y) {
        return ItemStack.of(CraftingRecipeInputUtil.getStack(input, x, y));
    }

    public static StackedContents getRecipeMatcher(CraftingInput input) {
        return input.stackedContents();
    }

    public static StackedContents getRecipeMatcher(CompatRecipeInput<?> input) {
        Optional<CraftingInput> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return null;
        }
        return CraftingRecipeInputUtil.getRecipeMatcher(recipeInput.get());
    }

    public static List<net.minecraft.world.item.ItemStack> getStacks(CraftingInput input) {
        return input.items();
    }

    public static List<net.minecraft.world.item.ItemStack> getStacks(CompatRecipeInput<?> input) {
        Optional<CraftingInput> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return null;
        }
        return CraftingRecipeInputUtil.getStacks(recipeInput.get());
    }

    public static int getWidth(CraftingInput input) {
        return input.width();
    }

    public static int getWidth(CompatRecipeInput<?> input) {
        Optional<CraftingInput> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return -1;
        }
        return CraftingRecipeInputUtil.getWidth(recipeInput.get());
    }

    public static int getHeight(CraftingInput input) {
        return input.height();
    }

    public static int getHeight(CompatRecipeInput<?> input) {
        Optional<CraftingInput> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return -1;
        }
        return CraftingRecipeInputUtil.getHeight(recipeInput.get());
    }

    public static int getStackCount(CraftingInput input) {
        return input.ingredientCount();
    }

    public static int getStackCount(CompatRecipeInput<?> input) {
        Optional<CraftingInput> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return -1;
        }
        return CraftingRecipeInputUtil.getStackCount(recipeInput.get());
    }
}

