/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.v2;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.pitan76.mcpitanlib.api.tag.TagKey;
import net.pitan76.mcpitanlib.api.util.IdentifierUtil;
import net.pitan76.mcpitanlib.api.util.ItemUtil;

public class ItemUtilV2 {
    public static List<Item> getItems(TagKey<Item> tagKey) {
        return ItemUtilV2.getItems(tagKey, ItemUtil.getAllItems());
    }

    public static List<Item> getItems(TagKey<Item> tagKey, List<Item> items) {
        ArrayList<Item> result = new ArrayList<Item>();
        for (Item item : items) {
            if (!ItemUtil.isIn(item, tagKey)) continue;
            result.add(item);
        }
        return result;
    }

    public static List<Item> getItems(ResourceLocation identifier) {
        return ItemUtilV2.getItems(TagKey.create(TagKey.Type.ITEM, identifier));
    }

    public static List<Item> getItems(ResourceLocation identifier, List<Item> items) {
        return ItemUtilV2.getItems(TagKey.create(TagKey.Type.ITEM, identifier), items);
    }

    public static List<Item> getItems(String id) {
        return ItemUtilV2.getItems(IdentifierUtil.id(id));
    }

    public static List<Item> getItems(String id, List<Item> items) {
        return ItemUtilV2.getItems(IdentifierUtil.id(id), items);
    }

    public static boolean isItemInTag(Item item, ResourceLocation identifier) {
        return ItemUtil.isIn(item, TagKey.create(TagKey.Type.ITEM, identifier));
    }

    public static boolean isItemInTag(Item item, String id) {
        return ItemUtilV2.isItemInTag(item, IdentifierUtil.id(id));
    }
}

