/*
 * Decompiled with CFR 0.152.
 */
package chappie.modulus.client.gui;

import chappie.modulus.client.gui.ModulusMainScreen;
import chappie.modulus.util.ClientUtil;
import chappie.modulus.util.CommonUtil;
import chappie.modulus.util.IHasTimer;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5489;
import net.minecraft.class_6379;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;

public class ChappModListWidget
extends class_4265<ChappEntry> {
    public static final Map<String, Consumer<ChappEntry>> MOD_CLICKED = Maps.newHashMap();
    private static final Supplier<JsonObject> JSON_LIST = CommonUtil.getJsonFromLink("https://raw.githubusercontent.com/ChappiePie/ModulusResources/main/modList.json");
    private final int listWidth;
    private final TextRenderable DEFAULT_TEXT = (entry, font, x, guiGraphics, entryIdx, top, left, entryWidth, entryHeight, mouseX, mouseY, isHovered, partialTick) -> {
        boolean b = entryIdx % 2 == 0;
        int initX = x.get();
        x.set(initX + (b ? left + 128 : left - 12) + 6);
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        class_5250 modName = class_2561.method_43470((String)(entry.modInfo.modInfo() == null ? entry.modInfo.modId : entry.modInfo.modInfo().getName())).method_27696(ClientUtil.BOLD_MINECRAFT);
        float f = 2.5f;
        poseStack.method_22905(f, f, f);
        poseStack.method_46416(b ? (float)(x.get() + 5) / f : (float)(entryWidth - 128) / f - (float)font.method_27525((class_5348)modName), (float)(top + 5) / f, 0.0f);
        guiGraphics.method_51439(font, (class_2561)modName, 0, 0, -1, true);
        poseStack.method_22909();
        List list = entry.modInfo.modInfo() == null ? entry.modInfo.text : class_2561.method_43470((String)entry.modInfo.modInfo().getDescription()).method_44746();
        class_5489 label = class_5489.method_61132((class_327)font, (int)(entryWidth - 160), (int)7, (class_2561[])list.toArray(new class_2561[0]));
        poseStack.method_22903();
        int y = top + 27;
        guiGraphics.method_25294(x.get() + 4, y, x.get() + 10 + label.method_44048(), y + 2, -1);
        int n = x.get() + 8;
        Objects.requireNonNull(font);
        label.method_30893(guiGraphics, n, y += 4, 9, 0xFFFFFF);
        int newX = b ? x.get() + 4 : x.get() + 10 + label.method_44048();
        Objects.requireNonNull(font);
        int yMax = y + 9 * label.method_30887() + 3;
        guiGraphics.method_25294(newX, y - 4, newX + 2, yMax, -1);
        poseStack.method_22909();
        x.set(initX + (b ? left : entryWidth - 128));
    };
    private final ModulusMainScreen screen;

    public ChappModListWidget(ModulusMainScreen screen, int listWidth, int top2, int bottom) {
        super(class_310.method_1551(), listWidth, bottom - top2, top2, 110);
        this.screen = screen;
        this.listWidth = listWidth;
        this.refreshList();
    }

    protected void method_57715(class_332 guiGraphics) {
    }

    protected int method_65507() {
        return this.listWidth;
    }

    public int method_25322() {
        return this.listWidth - 20;
    }

    public void refreshList() {
        this.method_25339();
        for (Map.Entry e : JSON_LIST.get().entrySet()) {
            Object v = e.getValue();
            if (!(v instanceof JsonObject)) continue;
            JsonObject json = (JsonObject)v;
            this.method_25321((class_350.class_351)new ChappEntry(this.screen, new ChappModInfo((String)e.getKey(), json.get("version").getAsString(), json.get("url").getAsString(), CommonUtil.parseDescriptionLines(json.get("description")), json.has("textureId") ? json.get("textureId").getAsString() : (String)e.getKey(), this.DEFAULT_TEXT)));
        }
    }

    protected void method_44397(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTick, int pIndex, int pLeft, int pTop, int pWidth, int pHeight) {
        int colorIn = class_9848.method_61324((int)150, (int)0, (int)0, (int)0);
        int colorOut = class_9848.method_61324((int)50, (int)255, (int)255, (int)255);
        this.method_44398(guiGraphics, pTop, pWidth, pHeight - 8, colorOut, colorIn);
        super.method_44397(guiGraphics, pMouseX, pMouseY, pPartialTick, pIndex, pLeft, pTop, pWidth, pHeight);
    }

    public void tick() {
        if (!JSON_LIST.get().isEmpty() && this.method_25396().isEmpty()) {
            this.refreshList();
        }
    }

    @FunctionalInterface
    public static interface TextRenderable {
        public void render(ChappEntry var1, class_327 var2, AtomicInteger var3, class_332 var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, boolean var12, float var13);
    }

    public static class ChappEntry
    extends class_4265.class_4266<ChappEntry>
    implements IHasTimer {
        public final Map<class_339, BiFunction<Integer, Integer, class_241>> children;
        public final ChappModInfo modInfo;
        public final ModulusMainScreen parent;
        private final IHasTimer.Timer titleTimer = new IHasTimer.Timer(() -> 10, () -> false);
        private final IHasTimer.Timer highlightTimer = new IHasTimer.Timer(() -> 10, () -> false);

        ChappEntry(ModulusMainScreen parent, ChappModInfo info) {
            String version;
            this.parent = parent;
            this.modInfo = info;
            this.children = new HashMap<class_339, BiFunction<Integer, Integer, class_241>>();
            ModMetadata modFile = info.modInfo();
            String string = version = modFile != null ? modFile.getVersion().getFriendlyString() : info.version;
            if (version.equals("${version}")) {
                version = "1.0";
            }
            MyButton versionButton = new MyButton(68, 16, (class_2561)class_2561.method_43469((String)"screen.modulus.modEntry.version", (Object[])new Object[]{version}), b -> {});
            versionButton.field_22763 = false;
            this.children.put((class_339)versionButton, (x, y) -> new class_241((float)(4 + x), (float)(76 + y)));
            if (modFile == null) {
                this.children.put((class_339)new MyButton(68, 16, (class_2561)class_2561.method_43471((String)"screen.modulus.modEntry.download"), b -> class_156.method_668().method_670(info.url)), (x, y) -> new class_241((float)(74 + x), (float)(76 + y)));
            }
        }

        public void method_25343(class_332 guiGraphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float partialTick) {
            class_327 font = class_310.method_1551().field_1772;
            AtomicInteger x = new AtomicInteger(6);
            int y = top;
            this.modInfo.textRenderable.render(this, font, x, guiGraphics, entryIdx, y, left, entryWidth, entryHeight, mouseX, mouseY, isHovered, partialTick);
            int mainColor = class_9848.method_61324((int)255, (int)108, (int)108, (int)108);
            int offColor = class_9848.method_61324((int)255, (int)56, (int)56, (int)56);
            int minX = x.get() - 4;
            int minY = (y += 6) - 4;
            int maxX = x.get() + 128 + 4;
            int maxY = y + 67 + 7;
            boolean isHoveredMod = mouseX > minX && mouseX < maxX && mouseY > minY && mouseY < maxY;
            guiGraphics.method_25294(minX, minY, maxX, maxY, mainColor);
            guiGraphics.method_25294(minX, maxY, maxX, maxY + 15, offColor);
            this.titleTimer.predicate = () -> isHoveredMod;
            this.titleTimer.update();
            float f = this.titleTimer.value(partialTick);
            f *= class_3532.method_15374((float)((float)entryIdx + (float)(class_156.method_658() % 1000L) / 1000.0f * ((float)Math.PI * 2))) / 2.0f;
            this.highlightTimer.predicate = () -> isHoveredMod;
            this.highlightTimer.update();
            float ht = 0.75f - this.highlightTimer.value(partialTick) * 0.5f;
            if (MOD_CLICKED.containsKey(this.modInfo.modId)) {
                ht = 0.75f + this.highlightTimer.value(partialTick) * 0.25f;
            }
            ClientUtil.blit(guiGraphics, this.modInfo.texture, (float)x.get() + 6.0f * f, (float)(y + 2) + 3.0f * f, 0.0f, 0.0f, 128.0f / (1.0f + f / 10.0f), 64.0f / (1.0f + f / 10.0f), 2048.0f, 1024.0f, 2048.0f, 1024.0f, class_9848.method_61318((float)1.0f, (float)ht, (float)ht, (float)ht));
            for (Map.Entry<class_339, BiFunction<Integer, Integer, class_241>> e : this.children.entrySet()) {
                class_241 vec2 = e.getValue().apply(x.get(), y);
                e.getKey().method_46421((int)vec2.field_1343);
                e.getKey().method_46419((int)vec2.field_1342);
                e.getKey().method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
            if (this.titleTimer.predicate.get().booleanValue() && pButton == 0 && MOD_CLICKED.containsKey(this.modInfo.modId)) {
                MOD_CLICKED.get(this.modInfo.modId).accept(this);
            }
            return super.method_25402(pMouseX, pMouseY, pButton);
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return new ArrayList<class_339>(this.children.keySet());
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return new ArrayList<class_339>(this.children.keySet());
        }

        public ChappModInfo getInfo() {
            return this.modInfo;
        }

        @Override
        public Iterable<IHasTimer.Timer> timers() {
            return Collections.singleton(this.titleTimer);
        }
    }

    public record ChappModInfo(String modId, String version, String url, List<class_2561> text, class_2960 texture, TextRenderable textRenderable) {
        public ChappModInfo(String modId, String version, String url, List<class_2561> text, String textureId, TextRenderable textRenderable) {
            this(modId, version, url, text, ModulusMainScreen.getTexByName("mods/%s".formatted(textureId)), textRenderable);
        }

        public ModMetadata modInfo() {
            Optional v = FabricLoader.getInstance().getModContainer(this.modId);
            return v.map(ModContainer::getMetadata).orElse(null);
        }
    }

    public static class MyButton
    extends class_4185 {
        private final class_241 oldSize = new class_241((float)this.method_25368(), (float)this.method_25364());

        public MyButton(int pWidth, int pHeight, class_2561 pMessage, class_4185.class_4241 pOnPress) {
            this(4, 0, pWidth, pHeight, pMessage, pOnPress);
        }

        public MyButton(int pX, int pY, int pWidth, int pHeight, class_2561 pMessage, class_4185.class_4241 pOnPress) {
            super(pX, pY, pWidth, pHeight, pMessage, pOnPress, class_4185.field_40754);
        }

        public void method_48579(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            class_4587 pPoseStack = guiGraphics.method_51448();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            pPoseStack.method_22903();
            float f = 0.75f;
            pPoseStack.method_22905(f, f, 1.0f);
            f = 1.0f / f;
            pPoseStack.method_46416((float)this.method_46426() * f, (float)this.method_46427() * f, 0.0f);
            guiGraphics.method_52707(class_1921::method_62277, ModulusMainScreen.SPRITES.method_52729(this.field_22763, this.method_25367()), 0, 0, (int)this.oldSize.field_1343, (int)this.oldSize.field_1342, class_9848.method_61317((float)this.field_22765));
            pPoseStack.method_22909();
            pPoseStack.method_22903();
            float f1 = 0.5f;
            pPoseStack.method_22905(f1, f1, 1.0f);
            f1 = 1.0f / f1;
            pPoseStack.method_46416((float)this.method_46426() * f1, (float)this.method_46427() * f1, 0.0f);
            guiGraphics.method_44379(6, 5, (int)(this.oldSize.field_1343 * f + 8.0f), (int)(this.oldSize.field_1342 + 3.0f));
            MyButton.method_52718((class_332)guiGraphics, (class_327)class_310.method_1551().field_1772, (class_2561)this.method_25369(), (int)6, (int)-10, (int)((int)((float)((int)this.oldSize.field_1343) * f + 6.0f)), (int)((int)(this.oldSize.field_1342 * f1 + 2.0f)), (int)(0xA0A0A0 | class_3532.method_15386((float)255.0f) << 24));
            guiGraphics.method_44380();
            pPoseStack.method_22909();
            this.method_25358((int)((this.oldSize.field_1343 - 5.0f) / f));
            this.method_53533((int)(this.oldSize.field_1342 / f));
            this.method_46421(this.method_46426() - 2);
        }

        public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
            super.method_25402(pMouseX, pMouseY, pButton);
            return false;
        }
    }
}

